  
#include <Adafruit_TinyUSB.h>
#include "ramdisk.h"
#include <Adafruit_GFX.h>
#include <KS0108_GLCD.h>
#include <TinyUSB_Mouse_and_Keyboard.h>
#include <TimeLib.h>

#include "tree.h"
#include "graphics.h"
#include "include.h"

// ---------------------------------------- 

void setup() { 
  usb_msc_enable(true);
  usb_msc.begin();  

  Serial.begin(115200);
  Serial.setTimeout(SERIAL_TIMEOUT);
  Keyboard.begin();
  Keyboard.releaseAll(); 
  
  pinMode( BGL_PIN, OUTPUT_12MA );

  GLCD_Init();

  // - - - - - - - - - - - - - - - - - 

  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i], OUTPUT ),
    digitalWrite( rowPins[i], HIGH ),
    gpio_set_slew_rate( rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );
  
  // - - - - - - - - - - - - - - - - - 

  setState(BOOTING);
  Serial_flush();
  serial_timer = millis();

  while (!msc_ready) yield();
  while (!zero_booted) {
    if (Serial.available() || BOOTSEL) break;
    if ((millis()-T) > 1000) 
      GLCD_anim(), T = millis();
  }
  zero_booted = true;

  setState(BOOTED);
  setSyncProvider(requestSync);

  menu_init = tree::Init(&menuTree, menu_init);

  clearBuf();
  Home(true);
}
// ---------------------------------------------------------

void Home(bool init) {
  setState(HOME_ON);

  display.clearDisplay();

  display.drawBitmap(
    (display.width()-BMP_WIDTH)/2, 
    (display.height()-BMP_HEIGHT)/2, 
    home_bmp, 
    BMP_WIDTH, BMP_HEIGHT, 1
  );

  homeArtwork(data_stored);
  printTopBar("HOME");
  printHomeItems(2,15);
  BGL_set(ON);
}

// ---------------------------------------------------------

int getIndex(const char* key) {
  for (int i=0; i<ArrLen(homeScreen); i++)
    if (strcmp(key, (const char*)homeScreen[i].name) == 0)
      return i;
  return -1;
}
// ---------------------------------------------------------

bool checkHeader(char** key) {
  char *val  = strchr(*key, ' ');
  int  index = -1, 
       items = ArrLen(homeScreen);

  if (val == NULL) return false;

  *val  = '\0'; val++;
  index = getIndex(*key);

  if (strcmp(*key, "epoch") == 0) {
    clock_set(val);
    return true;
  }
  else if (strcmp(*key, "unread") == 0) {
    strcpy(sysData[0].content, val);
    BGL_set(ON);
    return true;
  }
  else if (index >= 0 || index < items) {
    if (strcmp(*key, "moon") == 0) {
      char *sep = strchr(val,' ');
      if (sep) {
        *sep = '\0'; sep++;
        setMoonDay(sep);
      }
    }
    strcpy(homeScreen[index].content, val);
    return true;
  }

  return false;
}
// ---------------------------------------------------------

void serialBitmap(int w = 0) {
  int16_t offset = (w > 0) ? (128-w)/2 : 0;
  int x = 0; 
  int y = 0;

  display.clearDisplay();
  serial_timer = millis();

  while ((millis()-serial_timer < 2000)) {
    if (Serial.available()) {
      char c = Serial.read();

      if (c == '\n') 
        x = 0, y++;
      else 
        display.drawPixel(x+offset, y, ((c == '1') ? 1 : 0)), 
        x++;

      serial_timer = millis();
    }
  }
  display.display();
  delay(2000);
  //while (!readKeyPad());
}
// ---------------------------------------------------------

namespace browser {
  const int BROWSER_LINES = 256;
  const char* star_text = "* = ";
  const char* squa_text = "# = ";
  char *lines[BROWSER_LINES];
  char links[16][32];
  char images[16][32];
  int lnk_index = 0;
  int img_index = 0;

  // - - - - - - - - - - - - - - - - - - - - - -

  void resetLinks() {
    for (int i=0; i<16; i++)
      links[i][0] = '\0',
      images[i][0] = '\0';
    lnk_index = img_index = 0;
  }

  // - - - - - - - - - - - - - - - - - - - - - -

  void Execute(const char* item) {
    display.setFont(NULL);
    GLCD_print("EXECUTING:",1,1);
    GLCD_print(item, 1, 0);
    while (!readKeyPad());
  }

  // - - - - - - - - - - - - - - - - - - - - - -

  void listLinks(uint8_t mode) {
    int key, x, y, N; x = y = 0;
    KeyMap *KP = nullptr;

    display.setTextWrap(false);
    display.setFont(&Picopixel);
    display.clearDisplay();
    display.setCursor(0, 4);

    N = (mode == 0) ? lnk_index : img_index;

    for (int i = y; i<(y+9); i++)
      if (i < N) display.println((mode == 0) ? links[i] : images[i]);
    display.display();
    
    while (1) {
      KP = readKeyPad();
      if (KP != NULL) {
        key = KP->key;

        if (key >= 10 || key == 5) {
          if (key == 5)
            Execute((mode)?images[y]:links[y]);
          break;
        }
        else if (key == 8 || key == 2) 
          y = ((key == 2) ? ((y > 0) ? y-1 : 0) : ((key == 8) ? ((y < N) ? y+1 : N) : y));
        else if (key == 4 || key == 6) {
          if (mode)
            x = ((key == 4) ? ((x > 0) ? x-1 : 0) : ((key == 6) ? ((x < strlen(images[y])) ? x+1 : x) : x));
          else
            x = ((key == 4) ? ((x > 0) ? x-1 : 0) : ((key == 6) ? ((x < strlen(links[y])) ? x+1 : x) : x));
        }

        display.clearDisplay();
        display.setCursor(0, 4);

        for (int i = y; i<(y+9); i++) {
          if (i < N) {
            if (mode)
              display.println(((i == y) ? (char*)(images[i]+x) : images[i]));
            else
              display.println(((i == y) ? (char*)(links[i]+x) : links[i]));
          }
          else
            display.println(" ");
        }
        display.display();
      }
      else if (BOOTSEL) {
        while (BOOTSEL);
        break;
      }
    }
  }
  // - - - - - - - - - - - - - - - - - - - - - -

  void Draw(int x, int y, int N) {
    display.clearDisplay();
    display.setCursor(0, 4);

    for (int i = y; i<(y+9); i++) {
      if (i < N)
        display.println(((i == y) ? (char*)(lines[i]+x) : lines[i]));
      else
        display.println(" ");
    }
    display.display();
  }
  // - - - - - - - - - - - - - - - - - - - - - -

  void Start(char *str = stdin_buf) {
    int key, x, y, N;
    char **ptr = &str;
    char *sep = strchr(*ptr, '\n');
    KeyMap *KP = nullptr;

    x = y = N  = 0;

    do {
      sep = strchr(*ptr, '\n');
      if (sep){ *sep = '\0';
        if (N < BROWSER_LINES)
          lines[N++] = *ptr;
        sep++;
        *ptr = sep;
      }
    } while (sep);

    display.setTextWrap(false);
    display.setFont(&Picopixel);

    Draw(x, y, N);
    
    while (1) {
      KP = readKeyPad();
      if (KP != NULL) {
        key = KP->key;

        if (key == 10) {
          break;
        }
        else if (key == 8 || key == 2) {
          y = ((key == 2) ? ((y > 0) ? y-1 : 0) : ((key == 8) ? ((y < N) ? y+1 : N) : y));
          Draw(x = 0, y, N);
        }
        else if (key == 4 || key == 6) {
          x = ((key == 4) ? ((x > 0) ? x-1 : 0) : ((key == 6) ? ((x < strlen(lines[y])) ? x+1 : x) : x));
          Draw(x, y, N);
        }
        else if (key == 11) {
          buf[0] = '\0';
          sprintf(
            buf, "\n  %02d links%s\n  %02d imgs%s\n", 
            lnk_index, ((lnk_index > 0) ? " (*)" : ""),
            img_index, ((img_index > 0) ? "  (#)" : "")
          );
          GLCD_msgBox(buf, false);

          while ( !(KP = readKeyPad()) );
          if (KP->key == 10 || KP->key == 12)
            listLinks(((key == 10) ? 0 : 1));

          display.setTextWrap(false);
          display.setFont(&Picopixel);
          Draw(x, y, N);
        }
      }
      else if (BOOTSEL) {
        while (BOOTSEL);
        break;
      }
    }

    display.setFont(NULL);
    display.setTextWrap(true);
    display.setTextSize(1);

    //checkLinks();

    stdin_available = false;
  }
}

// ---------------------------------------------------------


void loop() {
  bool stored, serial_busy, warning, smallFont = false;
  char *ptr, *msc_ptr, header[32];
  uint8_t webMode;

  if (stdin_available) {
    msc_ptr = stdin_buf;

    if (await_response || strstr(stdin_buf, "#FORCE\n")) {    
      if (strstr(msc_ptr, "#FORCE\n"))
        msc_ptr = strchr(msc_ptr, '\n')+1,
        smallFont = true;

      Reader(msc_ptr, smallFont);
      await_response = false;      
    }
    stdin_available = false;

    if (getState() == HOME_ON)
      Home(true);
    else
      Menu();
  }
  else if (Serial.available() > 0) { 
    buf_input[0] = '\0';
    header[0] = '\0';
    serial_timer = millis();
    serial_busy  = true;
    warning      = false;
    smallFont    = false;
    webMode      = 0;

    while (serial_busy && ((millis()-serial_timer)<SERIAL_TIMEOUT)) {
      if (Serial.available() > 0) {
        int n = Serial.readBytesUntil('\n', buf, sizeof(buf)-1); buf[n] = '\0';

        char *web  = strstr(buf, "#WEB");
        char *url  = strstr(buf, "#URLS");
        char *img  = strstr(buf, "#IMG");
        char *bmp  = strstr(buf, "#BITMAP");
        char *forc = strstr(buf, "#FORCE");
        char *warn = strstr(buf, "#WARN");
        char *head = strstr(buf, "#HEAD ");
        char *eof  = strstr(buf, "#EOF");

        serial_timer = millis();

        if (head) {
          head = strchr(head,' '); head++;
          strcpy(header, head);
          stored = checkHeader(&head);

          if (stored)
            data_stored = true;
        }
        else if (web) {
          webMode = 1;
          browser::resetLinks();
          stdin_available = true;
          stdin_buf[0] = '\0';
        }
        else if (url) {
          webMode = 2;
        }
        else if (img) {
          webMode = 3;
        }
        else if (bmp) {
          ptr = strchr(buf, ' ')+1;
          ptr = strchr(ptr, ' '); *ptr = '\0';
          ptr = strchr(buf, ' ')+1;
          int w = (ptr) ? atoi(ptr) : 0;
          serialBitmap(w);
          break;
        }
        else if (eof) {
          serial_busy = false;
        }
        else if (forc) {
          await_response = true;
          smallFont = true;
        }
        else if (warn) {
          warning = true;
        }
        else {
          if (webMode > 0) {
            if (webMode == 1) {
              if ((strlen(stdin_buf)+strlen(buf))+2 < sizeof(stdin_buf)-1)
                strcat(stdin_buf, buf),
                strcat(stdin_buf, "\n");
            }
            else if (webMode == 2) {
              if (browser::lnk_index < 16 && strstr(buf, "http"))
                strncpy(browser::links[browser::lnk_index++], buf, 32);
            }
            else if (webMode == 3) {
              if (browser::img_index < 16 && strstr(buf, "http"))
                strncpy(browser::images[browser::img_index++], buf, 32);
            }
          }
          else {
            if ((strlen(buf_input)+strlen(buf))+2 < sizeof(buf_input)-1)
              strcat(buf_input, buf),
              strcat(buf_input, "\n");            
          }
        }
      }
    }
    Serial_flush();
    
    if (webMode) {
      browser::Start(stdin_buf);
      //browsStart(stdin_buf);
      //webBrowser();
    }
    else if (await_response) {
      Reader(buf_input, smallFont),
      await_response = false;
    }
    else if (warning) {
      showWarning(buf_input);
    }

    Home(true);
  }
  else {
    KeyMap *KP = readKeyPad();

    if (KP != NULL) { 
      //BGL_set(ON);
      if (bgl_pwm == 0)
        BGL_set(ON);
      else if (getState() == MENU_ON) {
        tree::Navigate(KP->key);
      }
      else if (getState() == HOME_ON) {
        Menu();
      }
      else if (getState() == TXT_INPUT) {
        if (KP_T9_getChar(KP)) {
          display.cp437(true); 
          GLCD_print("> ",0,1);
          GLCD_decodeStr(buf_input);
          display.write(curSym);
          KP_showIcon(true);
        }
      }
    }
    else if (BOOTSEL) { kp_last_press = millis();
      while (BOOTSEL) 
        if ((millis()-kp_last_press) > 2000) 
          break;

      if ((millis()-kp_last_press) < 2000) {
        if (getState() == TXT_INPUT)
          setState(sys_status_prev.id),
          sendCommand();
        else
        if (getState() == AWAIT_RESP) {
          stdin_available = false;  
          await_response = false;
          Menu();
        }
      }
    }
    else if (getState() == AWAIT_RESP) {
      if ((millis()-resp_timer) > RESP_TIMEOUT) {
        GLCD_msgBox("\n    RESPONSE\n    TIMEOUT\n", false); delay(2000);
        stdin_available = false;  
        await_response = false;
        Menu();
      }
      else 
        GLCD_anim();
    }
  }
  sysTick();
}


//###################################################################

