#ifndef TREE_H
#define TREE_H

#include <Arduino.h>

#ifdef __cplusplus
 extern "C" {
#endif

void cmd_myFun(const char* param);
void cmd_sendLcdBuf(const char* param);
void cmd_txtInput(const char* param);
void cmd_sketch(const char* param);
void cmd_smsRead(const char* param);
void cmd_smsSend(const char* param);
void cmd_smsInbox(const char* param);
void cmd_smsPb(const char* param);
void cmd_webBrowser(const char* param);

#ifdef __cplusplus
}
#endif

struct TreeNode {
  const char*  label;
  uint16_t     id;
  void        (*action)(const char *);
  const char*  params;
  struct       TreeNode* parent;
  uint8_t      sub_count;
  struct       TreeNode* children[8];
};

extern struct TreeNode menuTree;

#endif
