#include <Adafruit_TinyUSB.h>
#include "ramdisk.h"
#include <Adafruit_GFX.h>
#include <KS0108_GLCD.h>
#include <TinyUSB_Mouse_and_Keyboard.h>
#include <TimeLib.h>

#include "tree.h"
#include "graphics.h"
#include "include.h"

// ---------------------------------------- 

void setup() { 
  usb_msc_enable(true);
  usb_msc.begin();  

  Serial.begin(115200);
  Serial.setTimeout(SERIAL_TIMEOUT);
  Keyboard.begin();
  Keyboard.releaseAll(); 
  
  pinMode( BGL_PIN,     OUTPUT_12MA );
  pinMode( LED_BUILTIN, OUTPUT);

  digitalWrite(LED_BUILTIN, HIGH);
  GLCD_Init();

  // - - - - - - - - - - - - - - - - - 

  for (int i = 0; i < row_N; i++)
    pinMode( rowPins[i], OUTPUT ),
    digitalWrite( rowPins[i], HIGH ),
    gpio_set_slew_rate( rowPins[i], GPIO_SLEW_RATE_SLOW);
  
  for (int i = 0; i < col_N; i++)
    pinMode( colPins[i], INPUT_PULLUP );
  
  // - - - - - - - - - - - - - - - - - 

  setState(BOOTING);
  Serial_flush();
  serial_timer = millis();

  while (!msc_ready) yield();
  while (!zero_booted) {
    if (Serial.available() || BOOTSEL) break;
    if ((millis()-T) > 1000) 
      GLCD_anim(), T = millis();
  }
  zero_booted = true;

  setState(BOOTED);
  setSyncProvider(requestSync);

  menu_init = tree::Init(&menuTree, menu_init);

  clearBuf();
  Home(true);
}
// ---------------------------------------------------------

void loop() {
  bool stored, serial_busy, warning, smallFont = false;
  char *ptr, *msc_ptr, header[32];
  int param, webMode;

  if (stdin_available) {
    msc_ptr = stdin_buf;

    if (await_response || strstr(stdin_buf, "#FORCE\n")) {    
      if (strstr(msc_ptr, "#FORCE\n"))
        msc_ptr = strchr(msc_ptr, '\n')+1,
        smallFont = true;

      Reader(msc_ptr, smallFont);
      await_response = false;      
    }
    stdin_available = false;

    if (getState() == HOME_ON)
      Home(true);
    else
      Menu();
  }
  else if (Serial.available() > 0) { 
    buf_input[0] = '\0';
    header[0] = '\0';
    serial_timer = millis();
    serial_busy  = true;
    warning      = false;
    smallFont    = false;
    webMode      = 0;

    while (serial_busy && ((millis()-serial_timer)<SERIAL_TIMEOUT)) {
      if (Serial.available() > 0) {
        int n = Serial.readBytesUntil('\n', buf, sizeof(buf)-1); buf[n] = '\0';

        char *web  = strstr(buf, "#WEB");
        char *url  = strstr(buf, "#URLS");
        char *img  = strstr(buf, "#IMG");
        char *bmp  = strstr(buf, "#BITMAP");
        char *forc = strstr(buf, "#FORCE");
        char *warn = strstr(buf, "#WARN");
        char *head = strstr(buf, "#HEAD ");
        char *eof  = strstr(buf, "#EOF");

        serial_timer = millis();

        if (head) {
          head = strchr(head,' '); head++;
          strcpy(header, head);
          stored = checkHeader(&head);

          if (stored)
            data_stored = true;
        }
        else if (web) {
          webMode = 1;
          browser::resetLinks();
          stdin_available = true;
          stdin_buf[0] = '\0';
        }
        else if (url) {
          webMode = 2;
        }
        else if (img) {
          webMode = 3;
        }
        else if (bmp) {
          ptr = strchr(buf, ' ')+1;
          ptr = strchr(ptr, ' '); *ptr = '\0';
          ptr = strchr(buf, ' ')+1;
          param = (ptr) ? atoi(ptr) : 0;
          serialBitmap(param);
          Serial_flush();
          while (!readKeyPad());
          return;
          //break;
        }
        else if (eof) {
          serial_busy = false;
        }
        else if (forc) {
          await_response = true;
          smallFont = true;
        }
        else if (warn) {
          if (strchr(buf, ' ')) {
            ptr = strchr(buf, ' ')+1;
            param = (ptr) ? atoi(ptr) : 5000;       
          }
          warning = true;
        }
        else {
          if (webMode > 0) {
            if (webMode == 1) {
              if ((strlen(stdin_buf)+strlen(buf))+2 < sizeof(stdin_buf)-1)
                strcat(stdin_buf, buf),
                strcat(stdin_buf, "\n");
            }
            else if (webMode == 2) {
              if (browser::lnk_index < 16 && strstr(buf, "http"))
                strncpy(browser::links[browser::lnk_index++], buf, LINK_LENGTH);
            }
            else if (webMode == 3) {
              if (browser::img_index < 16 && strstr(buf, "http"))
                strncpy(browser::images[browser::img_index++], buf, LINK_LENGTH);
            }
          }
          else {
            if ((strlen(buf_input)+strlen(buf))+2 < sizeof(buf_input)-1)
              strcat(buf_input, buf),
              strcat(buf_input, "\n");            
          }
        }
      }
    }
    Serial_flush();
    
    if (webMode) {
      browser::Start(stdin_buf);
      stdin_available = false;
    }
    else if (await_response) {
      Reader(buf_input, smallFont),
      await_response = false;
    }
    else if (warning) {
      showWarning(buf_input, param);
    }

    Home(true);
  }
  else {
    KeyMap *KP = readKeyPad();

    if (KP != NULL) { 
      //BGL_set(ON);
      if (bgl_pwm == 0)
        BGL_set(ON);
      else if (getState() == MENU_ON) {
        tree::Navigate(KP->key);
      }
      else if (getState() == HOME_ON) {
        Menu(true);
      }
      else if (getState() == TXT_INPUT) {
        if (KP_T9_getChar(KP)) {
          display.cp437(true); 
          GLCD_print("> ",0,1);
          GLCD_decodeStr(buf_input);
          display.write(curSym);
          KP_showIcon(true);
        }
      }
    }
    else if (BOOTSEL) { kp_last_press = millis();
      while (BOOTSEL) 
        if ((millis()-kp_last_press) > 2000) 
          break;

      if ((millis()-kp_last_press) < 2000) {
        if (getState() == TXT_INPUT)
          setState(sys_status_prev.id),
          sendCommand();
        else
        if (getState() == AWAIT_RESP) {
          stdin_available = false;  
          await_response = false;
          Menu();
        }
      }
    }
    else if (getState() == AWAIT_RESP) {
      if ((millis()-resp_timer) > RESP_TIMEOUT) {
        GLCD_msgBox("\n    RESPONSE\n    TIMEOUT\n", false); delay(2000);
        stdin_available = false;  
        await_response = false;
        Menu();
      }
      else 
        GLCD_anim();
    }
  }
  sysTick();
}


//###################################################################

