#include <Arduino.h>
#include <stdio.h>
#include <pico/stdlib.h>
#include <hardware/uart.h>

#define ArrLen(x)     (sizeof(x)/sizeof(x[0]))
#define mySerial      Serial1
#define BGL_PIN       28
#define BGL_TIMEOUT   30000UL
#define DEBOUNCE      50


const uint8_t row_N = 4;
const uint8_t col_N = 6;
unsigned long kp_last_press;

uint8_t lcdPins[] = { 22, 20, 21, 19, 18, 17, 16, 26, 27, 5, 4, 3, 2 };

uint8_t rowPins[row_N] = {
  7,    // KP 2
  14,   // KP 5
  10,   // KP 7
  11    // KP 8
};

uint8_t colPins[col_N] = {
  6,    // KP 1
  8,    // KP 3
  9,    // KP 4
  15,   // KP 6
  12,   // KP 9
  13    // KP 10
};


char    c_last;
char    buf_input[256];
uint8_t buf_index;

struct Map {
  uint8_t     pin;
  uint8_t     key;
  int16_t     index;
  const char* t9_page;
};

enum : int {
  T9_SYMBOLS = 1,
  T9_ABC,
  T9_DEF,
  T9_GHI,
  T9_JKL,
  T9_MNO,
  T9_PQRS,
  T9_TUV,
  T9_WXYZ,
  T9_BACKSPACE,
  T9_DIGITS,
  T9_SPACE
};

Map matrix[4][3] = {
  {
    { colPins[0], 1, 0, ".,!?:;_-+=*/'\"%$&#@(){}[]"},
    { colPins[2], 2, 0, "abcABC"},
    { colPins[1], 3, 0, "defDEF"},
  },
  {
    { colPins[0], 4, 0, "ghiGHI"},
    { colPins[2], 5, 0, "jklJKL"},
    { colPins[3], 6, 0, "mnoMNO"}
  },
  {
    { colPins[0], 7, 0, "pqrsPQRS"},
    { colPins[2], 8, 0, "tuvTUV"},
    { colPins[3], 9, 0, "wxyzWXYZ"}
  },
  {
    { colPins[2], 11, 0, ""},
    { colPins[5], 10, 0, "0123456789"},
    { colPins[4], 12, 0, " "}
  },
};


/* ----------------------------------------------------------------------------------------- */

void setup()   {
  delay(1000);
  Serial.begin(9600);

  while (!Serial && millis()<3000);
  Serial.println(F("READY."));

  /*
  for (int i = 0; i < ArrLen(lcdPins); i++)
    pinMode(lcdPins[i], OUTPUT),
    digitalWrite(lcdPins[i], LOW);
  */
  for (int i = 0; i < row_N; i++)
    pinMode(rowPins[i], OUTPUT),
    digitalWrite(rowPins[i], HIGH);
  
  for (int i = 0; i < col_N; i++)
    pinMode(colPins[i], INPUT_PULLUP);

  pinMode(LED_BUILTIN, OUTPUT);
  digitalWrite(LED_BUILTIN, LOW);

  //pinMode(BGL_PIN, OUTPUT_12MA);
  //digitalWrite(BGL_PIN, HIGH);

  memset(buf_input, 0, sizeof(buf_input));
  c_last = '\0';
  buf_index = 0;

  kp_last_press = millis();
}
// ---------------------------------------------------------------

Map *readKeyPad() {
  uint8_t key = 0;
  
  for (uint8_t row = 0; row < 4; row++) {
    digitalWrite(rowPins[row], LOW);
    
    for (uint8_t col = 0; col < 3; col++) {
      uint8_t col_pin = matrix[row][col].pin;
        
      if (digitalRead(col_pin) == LOW) {
        if ((millis()-kp_last_press) > DEBOUNCE) {
          digitalWrite(LED_BUILTIN, HIGH);
          key = matrix[row][col].key;
          
          while (digitalRead(col_pin) == LOW); 
          
          digitalWrite(LED_BUILTIN,  LOW);
          digitalWrite(rowPins[row], HIGH);
          kp_last_press = millis();
          
          return &(matrix[row][col]);
        }
      }
    }
    digitalWrite(rowPins[row], HIGH);
  }
  return nullptr;
}
// ---------------------------------------------------------------

void t9_reset() {
  for (uint8_t x = 0; x < 4; x++) 
    for (uint8_t y = 0; y < 3; y++) 
      matrix[x][y].index = 0;
}
// ---------------------------------------------------------------

char kp_last_char = '\0';
int16_t kp_last_index = 0;

void loop() {
  uint8_t key, index;
  char c;
  
  Map *obj = readKeyPad();

  if (BOOTSEL) { 
    while (BOOTSEL);

    if (strlen(buf_input) > 0) 
      Serial.print("SENDING '"), Serial.print(buf_input), Serial.println("'");
    
    memset(buf_input, 0, sizeof(buf_input));
    t9_reset();
    buf_index = 0;
  }
  else {
    if (obj != NULL) {
      key = obj->key;

      if (obj->index < 1) {
        if (buf_input[buf_index] != '\0' && key < 11) 
          buf_index++;
        t9_reset();
      } else {
        if (key == 12) 
          buf_index++;
      }
      
      if (key == 11) {
        buf_input[buf_index] = '\0';
        if (buf_index > 0) buf_index--;
      }

      index = obj->index % strlen(obj->t9_page);
      
      if (strlen(obj->t9_page) > 0) {
        c = obj->t9_page[index];        
        if (!(key == 12 && obj->index == 0)) 
          buf_input[buf_index] = c;
          
        obj->index++;
      }
      // emulate terminal output
      Serial.print("> "), Serial.println(buf_input);
    }
  }
}


/*
WORKING MED SPACE OG BACKSPACE!
void loop() {
  uint8_t key, index;
  char c;
  
  Map *obj = readKeyPad();

  if (BOOTSEL) { 
    Serial.println("BOOTSEL!");
  }
  else {
    if (obj != NULL) {
      key = obj->key;

      if (obj->index < 1) {
        if (buf_input[buf_index] != '\0' && key < 11) 
          buf_index++;
        t9_reset();
      } else {
        if (key == 12) 
          buf_index++;
      }
      
      if (key == 11) {
        buf_input[buf_index] = '\0';
        if (buf_index > 0) buf_index--;
      }

      index = obj->index % strlen(obj->t9_page);
      
      if (strlen(obj->t9_page) > 0) {
        c = obj->t9_page[index];        
        if (!(key == 12 && obj->index == 0)) 
          buf_input[buf_index] = c;
          
        obj->index++;
      }
      // emulate terminal output
      Serial.print("> "), Serial.println(buf_input);
    }
  }
}
*/


/*
WORKING SPACE ON DOUBLE PRESS!

void loop() {
  uint8_t key, index;
  char c;
  
  Map *obj = readKeyPad();

  if (BOOTSEL) { 
    Serial.println("BOOTSEL!");
  }
  else {
    if (obj != NULL) {
      key = obj->key;

      if (obj->index < 1) {
        if (buf_input[buf_index] != '\0' && key != 12) 
          buf_index++;
        t9_reset();
      } else {
        if (key == 12) 
          buf_index++;
      }

      index = obj->index % strlen(obj->t9_page);
      
      if (strlen(obj->t9_page) > 0) {
        c = obj->t9_page[index];
        
        if (!(key == 12 && obj->index == 0))
          buf_input[buf_index] = c;
          
        obj->index++;
        //if (!(key == 12 && obj->index == 0)) obj->index++;
      }


      
      Serial.println(buf_input);
    }
  }
}
*/

/*
 WORKING BUT NEEDS REWIND AT FIRST SPACE!
void loop() {
  uint8_t key, index;
  char c;
  
  Map *obj = readKeyPad();

  if (BOOTSEL) { 
    Serial.println("BOOTSEL!");
  }
  else {
    if (obj != NULL) {
      key = obj->key;

      if (obj->index < 1) {
        if (buf_input[buf_index] != '\0')
          buf_index++;
        t9_reset();
      }

      index = obj->index % strlen(obj->t9_page);
      
      if (strlen(obj->t9_page) > 0) {
        c = obj->t9_page[index];
        buf_input[buf_index] = c;
        obj->index++;   
      }
      Serial.println(buf_input);
    }
  }
}
// --------------------------------------------
*/

/*
void loop() {
  uint8_t key, index;
  char c;
  
  Map *obj = readKeyPad();

  if (BOOTSEL) { Serial.println("BOOTSEL!");
    while (BOOTSEL);
    if (c_last != '\0')
      buf_input[buf_index++] = c_last;
    buf_input[buf_index++] = '\0';
        
    if (strlen(buf_input) > 0) 
      Serial.print("Buffer: "), Serial.println(buf_input);
    
    memset(buf_input, 0, sizeof(buf_input));
    t9_reset();
    buf_index = 0;
    c_last = '\0';
  }
  else {
    if (obj != NULL) {
      key = obj->key;
      index = obj->index;
  
      if (index == 0 || key > 10) {
        if (c_last != '\0')
          buf_input[buf_index++] = c_last;

        t9_reset();
        
        if (key == 12) {
          if (index > 0)
            c = ' ',
            buf_input[buf_index++] = c,
            obj->index = 0;
          ++obj->index;
        }
          
        if (key == 11)
          buf_input[buf_index] = '\0',
          buf_index = (buf_index > 0) ? buf_index-1 : 0;

        c_last = '\0';
      }

      if (key < 11) {
        index = obj->index;
        c = obj->t9_page[index];

        ++obj->index %= strlen(obj->t9_page);
        c_last = c;  
      }
      Serial.print("pressed #"), Serial.print(key);   
      Serial.print(" @ index "), Serial.print(index);
      Serial.print(" -> '"), Serial.print(c);
      Serial.println("'\n-------------------------");
      
    }
  }
}
*/
// ---------------------------------------------------------------
