#!/bin/bash
home_dir=$(getent passwd pi | cut -d: -f6)
source_dir="$home_dir/ADMIN/.source"
backup_dir="$home_dir/ADMIN/.backup"
log_file="$source_dir/.log"
#_______________________________________________

exec > >(sudo tee $log_file 2>&1)

[ ! -d $source_dir ] && sudo mkdir -p $source_dir || sudo cp -r $source_dir "$source_dir.bak"
sudo chmod -R 775 $source_dir

[ ! -d $backup_dir ] && sudo mkdir -p $backup_dir
sudo chmod -R 775 $backup_dir

#_______________________________________________

echo -e "\n`date`"
echo -e "\nsource dir: $source_dir"

while read -r line; do

  path=$(echo $line | cut -d' ' -f1)
  type=$(echo $line | cut -d' ' -f2)
  echo -e "\n"
  echo -n "backing up $type: $path -> "

  if [[ "$type" = "FILE" ]]; then
     dir="$source_dir"; dir+=$(echo "$path" | awk -F/ '{ for (i=1; i<NF; i++) printf "%s/", $i ; printf "\n" }')
     sudo mkdir -p "$dir" && sudo chmod -R 775 "$dir"
     echo -e "$dir\n"
     sudo cp -v "$path" "$dir"
  elif [[ "$type" = "DIR" ]]; then
    dir=$(echo "$source_dir$path")
    [ -d $dir ] && sudo chmod -R 775 "$dir" || sudo mkdir -p "$dir" && sudo chmod -R 775 "$dir"
    echo -e "$dir\n"
    sudo cp -R -v "$path" "$dir"
  elif [[ "$type" = "ALL" ]]; then
    dir=$(echo "$source_dir$path")
    [ -d $dir ] && sudo chmod -R 775 "$dir" || sudo mkdir -p "$dir" && sudo chmod -R 775 "$dir"
    echo -e "$dir\n"
    sudo find "$path" -maxdepth 1 -type f -exec cp -v {} "$dir" \;
  fi

done< <(cat "$source_dir/list")

folder_size=$(sudo du -sh $source_dir | awk -F' ' '{print $1}' | sed 's/M//g')
echo -e "\nDONE!\n\nFOLDER SIZE: $folder_sizeM\n"
sleep 1

echo -e "ADD TO ARCHIVE? (Y/n)" && read -srN 1 myvar

[ -f $archive_name ] && echo "archive already exists.." || \
case $myvar in
  [Yy]) archive_name=$(echo "$source_dir" | awk -F'/' '{print $(NF-0)}' | sed 's/\.//g' | awk '{print $0 ".tar.gz"}')
	echo -e "\n\nWRITING ARCHIVE \x27$backup_dir/$archive_name\x27\n"
	sudo tar -czvf "$backup_dir/$archive_name" "$source_dir" #&& \
        archive_size=$(sudo du -sh "$backup_dir/$archive_name" | awk -F' ' '{print $1}' | sed 's/M//g')
        compression=$(awk -v var1="$archive_size" -v var2="$folder_size" 'BEGIN { print ( var1 / var2 ) }' | cut -c -4)
        echo -e "\nDONE!\n\nARCHIVE SIZE: $archive_sizeM ($compression%)"
        ;;
esac

