#!/bin/bash


# import HELPERS.SH
# this script uses the following functions from there
# 	joy2keyStart()
# 	joy2keyStop()
# needs the variable $scriptdor to be set
source /home/pi/RetroPie-Setup/scriptmodules/helpers.sh
scriptdir=~/RetroPie-Setup

# start JOY2KEY from the sourced file with cursor key for axis/DPAD, ENTER for A, TAB for B
		joy2keyStart kcub1 kcuf1 kcuu1 kcud1 0x0a 0x09
		
		log 2 "STARTED joy2key WITH RETURN CODE $?, PID ${__joy2key_pid}"

function getConfigValueToKey ()
{
	key="$1"
	log 3 "() \$key=${key}"
	
	log 3 "LOOKING FOR VALUE \"${key}\" IN ${configDir}/${system}/retroarch.cfg"
		
	local file=""
	
	value="$(grep --only-matching "^${key} = .*" "${configDir}/${system}/retroarch.cfg")"
	
	if [ "${value}" == "" ]
	then
		log 3 "LOOKING FOR VALUE \"${key}\" IN ${configDir}/all/retroarch.cfg"
		
		value="$(grep --only-matching "^${key} = .*" "${configDir}/all/retroarch.cfg")"
		
		if [ "${value}" == "" ]
		then
			log 1 "NO VALUE TO KEY \"${key}\" FOUND"
			return 1
		else
			file="${configDir}/all/retroarch.cfg"
		fi
	else
		file="${configDir}/${system}/retroarch.cfg"
	fi
	
	# remove key and " from result
	value=${value/$key = /}
	value=${value//\"/}
	eval value="${value}"
	
	log 3 "FOUND VALUE \"${value}\" TO KEY \"${key}\" IN ${file}"
	
	return 0
}

function setConfigValue ()
{
	key="$1"
	value="$2"
	
	log 3 "() \$key=${key} \$value=${value}"
	
	if [[ $(grep -c --only-matching "^${key} = .*" "${configDir}/${system}/retroarch.cfg") -eq 1 ]]
	then
		log 2 "UPDATING KEY ${key} TO VALUE ${value} IN ${configDir}/${system}/retroarch.cfg"
		sudo sed -i "/^${key} = /c\\${key} = \"${value}\"" ${configDir}/${system}/retroarch.cfg
	else
		if [[ $(grep -c --only-matching "^${key} = .*" "${configDir}/all/retroarch.cfg") -eq 1 ]]
		then
			log 2 "UPDATING KEY ${key} TO VALUE ${value} IN ${configDir}/all/retroarch.cfg"
			sudo sed -i "/^${key} = /c\\${key} = \"${value}\"" ${configDir}/all/retroarch.cfg
		else
			log 2 "ADDING KEY ${key} TO ${configDir}/${system}/retroarch.cfg"
			# add new parameter above "#include..."
			sudo sed -i "/^#include \"\/opt\/retropie\/configs\/all\/retroarch.cfg\"/c\\${key} = /c\\${key} = \"${value}\"\n#include \"\/opt\/retropie\/configs\/all\/retroarch.cfg\"" ${configDir}/${system}/retroarch.cfg
		fi
	fi
	
}
