#!/usr/bin/env python3 -*- coding: utf-8

import serial
import sys
import time
import os

path = "/tmp/pyserial.fifo"

#--------------------------------------------------
#
# SETUP:

try:
    print("opening fifo")
    fifo = open(path, "r")

except Exception as e:
    #print(f"error opening fifo: {e}")
    print("error opening fifo:",e)
    sys.exit()

#__________________________________________________
#
# FUNCTIONS:

def loop():

    with serial.Serial("/dev/ttyACM0", 9600, timeout=1) as arduino:
        time.sleep(0.1)

        while True:
            if arduino.isOpen():
                arduino.reset_input_buffer()

                try:
                    if arduino.inWaiting()==0:
                        msg = read_fifo()

                        if len(msg)>0:
                            arduino.write(msg.encode())
                            print("RPI->TEENSY: \x27" + msg + "\x27\n")

                    elif arduino.inWaiting()>0:
                        arduino.flushInput()
                        line = arduino.readline().decode('utf-8')
                        print("RPI<-TEENSY: \x27" + line + "\x27\n")
                        #nom = line.split()[0]
                        #if nom == 'RPI':
                        #    pos = line.find('RPI') + 4
                        #    print("RPI<-TEENSY: \x27" + line[pos:] + "\x27\n")
                        #    #time.sleep(1)
                        #time.sleep(1)
                        #arduino.flushInput()
                        #countdown = 10

                except KeyboardInterrupt:
                    print("KeyboardInterrupt has been caught.")
                    arduino.close()
                    fifo.close()
                    os._exit(1)

#--------------------------------------------------

def read_fifo():
    output = ''
    line = fifo.readline()

    if line:
        print ("FIFO:", line)
        output = line.replace('\n', '')
        output = output + ";"

    return str(output)

    #send_serial(output)

#--------------------------------------------------

#def send_serial(serial_str):
    #cmd = msg + ";"
    #serial_str = input.replace('\n', '')


#__________________________________________________


#def read_arduino():
#    line = arduino.readline().decode('utf-8')
#    nom = line.split()[0]
#
#    if nom == 'RPI':
#        pos = line.find('RPI') + 4
#        print("RPI<-TEENSY: " + line[pos:])
#        time.sleep(1)
#
#    arduino.flushInput()
#    #countdown = 10

#--------------------------------------------------


loop()
#while True:
#    loop()

fifo.close()
arduino.close()
sys.exit()

#while True:
#    try:
#        line = fifo.readline()
#        if line:
#            print ("Received:", line)
#
#    except KeyboardInterrupt:
#        fifo.close()
#
#fifo.close()

#if __name__ == '__main__':
#    loop()
#    print("DONE!")
#    #sys.exit()


#if __name__ == '__main__':
#    with serial.Serial("/dev/ttyACM0", 9600, timeout=1) as arduino:
#        time.sleep(0.1) #wait for serial to open
#        if arduino.isOpen():
#            arduino.reset_input_buffer()
#            try:
#                countdown = 10
#                cmd=(Path('/home/pi/CAFCA4/assets/serial/OUTBOX').read_text())
#                cmd = cmd + ";"
#                cmd = cmd.replace('\n', '')
#                arduino.write(cmd.encode())
#                print("RPI->TEENSY: " + cmd)
#
#                while arduino.inWaiting()==0: #pass
#                    print(countdown)
#                    countdown -= 1
#                    time.sleep(0.5)
#                    if countdown < 1:
#                        break
#
#                if arduino.inWaiting()>0:
#                    line = arduino.readline().decode('utf-8')
#                    nom = line.split()[0]
#
#                    if nom == 'RPI':
#                        pos = line.find('RPI') + 4
#                        print("RPI<-TEENSY: " + line[pos:])
#                        time.sleep(1)
#                    arduino.flushInput()
#                    countdown = 10
#
#            except KeyboardInterrupt:
#                print("KeyboardInterrupt has been caught.")
#            arduino.close()
