#!/usr/bin/env python3 -*- coding: utf-8 -*- lsusb to check device name
#dmesg | grep "tty" to find port name

import serial
import time
import os
from pathlib import Path

if __name__ == '__main__':
    with serial.Serial("/dev/ttyACM0", 9600, timeout=1) as arduino:
        time.sleep(0.1) #wait for serial to open
        if arduino.isOpen():
            arduino.reset_input_buffer()
            try:
                cmd = "REQ COIN;"
                cmd = cmd.replace('\n', '')
                arduino.write(cmd.encode())
                print("RPI->TEENSY: " + cmd)

            except KeyboardInterrupt:
                print("KeyboardInterrupt has been caught.")
            arduino.close()
