#!/usr/bin/env python3 -*- coding: utf-8 -*- lsusb to check device name
#dmesg | grep "tty" to find port name

import serial
import time
import os
from pathlib import Path

if __name__ == '__main__':
    with serial.Serial("/dev/ttyACM0", 9600, timeout=1) as arduino:
        time.sleep(0.1) #wait for serial to open
        if arduino.isOpen():
            arduino.reset_input_buffer()
            try:
                countdown = 10
                cmd=(Path('/home/pi/CAFCA4/assets/serial/OUTBOX').read_text())
                cmd = cmd + ";"
                cmd = cmd.replace('\n', '')
                arduino.write(cmd.encode())
                print("RPI->TEENSY: " + cmd)

                while arduino.inWaiting()==0: #pass
                    print(countdown)
                    countdown -= 1
                    time.sleep(0.5)
                    if countdown < 1:
                        break

                if arduino.inWaiting()>0:
                    line = arduino.readline().decode('utf-8')
                    nom = line.split()[0]

                    if nom == 'RPI':
                        pos = line.find('RPI') + 4
                        print("RPI<-TEENSY: " + line[pos:])
                        time.sleep(1)
                    arduino.flushInput()
                    countdown = 10

            except KeyboardInterrupt:
                print("KeyboardInterrupt has been caught.")
            arduino.close()
