#!/usr/bin/env python3 -*- coding: utf-8 -*- lsusb to check device name
#dmesg | grep "tty" to find port name

import serial
import time
import os
import subprocess
from pathlib import Path


if __name__ == '__main__':
    with serial.Serial("/dev/ttyACM0", 9600, timeout=1) as arduino:
    #with serial.Serial(port='/dev/ttyACM0', baudrate=9600, parity=serial.PARITY_NONE,stopbits=serial.STOPBITS_ONE, bytesize=serial.EIGHTBITS, timeout=1) as arduino:

        time.sleep(0.1) #wait for serial to open
        if arduino.isOpen():
            #print("{} connected!".format(arduino.port))
            arduino.reset_input_buffer()
            try:
                cmd= "ASLEEP 1"
                cmd = cmd + ";"
                cmd = cmd.replace('\n', '')
                arduino.write(cmd.encode())
                print("RPI->TEENSY: " + cmd)
                #print(cmd)
                while arduino.inWaiting()==0: pass
                if arduino.inWaiting()>0:
                    #line = arduino.readline().decode('utf-8').rstrip()
                    line = arduino.readline().decode('utf-8')
                    #print("LINE: " + line)
                    nom = line.split()[0]
                    #nom = line.split(" ",1)[0]
                    #print("NOM: " + nom)
                    if nom == 'RPI':
                       pos = line.find('RPI') + 4
                       print("RPI<-TEENSY: " + line[pos:])
                       #print(line[pos:])
                       #print(line)

                       time.sleep(1)
                    arduino.flushInput()

            except KeyboardInterrupt:
                print("KeyboardInterrupt has been caught.")
            arduino.close()
