#!/usr/bin/env python3 -*- coding: utf-8 -*- lsusb to check device name
#dmesg | grep "tty" to find port name

import serial
import time
import os
import subprocess
from pathlib import Path


if __name__ == '__main__':
    with serial.Serial("/dev/ttyACM0", 9600, timeout=1) as arduino:
        time.sleep(0.1) #wait for serial to open
        if arduino.isOpen():
            arduino.reset_input_buffer()
            try:
                wakecmd= "ASLEEP 0"
                wakecmd = wakecmd + ";"
                wakecmd = wakecmd.replace('\n', '')

                while arduino.inWaiting()==0: #pass
                    sleepstate=(Path('/home/pi/ADMIN/SLEEP/sleepstate').read_text())
                    sleepstate=sleepstate.rstrip()
                    #print("SLEEPSTATE: " + sleepstate)
                    if sleepstate != '1':
                       print("waitWakeSerial.py: WAKING UP!")
                       arduino.write(wakecmd.encode())
                       arduino.flushInput()
                       arduino.close()
                       quit()
                    time.sleep(1)
                if arduino.inWaiting()>0:
                    line = arduino.readline().decode('utf-8')
                    nom = line.split()[0]
                    if nom == 'RPI':
                       pos = line.find('RPI') + 4
                       msg = line[pos:]
                       if msg == 'WAKEUP':
                          print("RPI<-TEENSY: " + line[pos:])
                          time.sleep(1)
                          arduino.flushInput()
                          arduino.close()
            except KeyboardInterrupt:
                print("KeyboardInterrupt has been caught.")
            arduino.close()
