
#!/bin/bash
path=/home/pi/ADMIN
playsound=$(cat $path/SLEEP/playsound)

sudo python3 $path/SERIAL/reqTimeout2.py #&> /dev/null &
echo " " |& sudo tee $path/SLEEP/evdump &> /dev/null
sleep 1
evtest /dev/input/event* |& sudo tee $path/SLEEP/evdump &> /dev/null &

lastsize=0
storedsize=0
wait2wake=0
timeout=$(cat $path/SLEEP/timeout)
idlecount=$timeout

echo "0" | sudo tee $path/SLEEP/sleepstate &> /dev/null
asleep=$(cat $path/SLEEP/sleepstate)


function eventListener() {

    echo "1" | sudo tee $path/SLEEP/sleepstate &> /dev/null
    asleep=$(cat $path/SLEEP/sleepstate)

    tail -F $path/SLEEP/evdump |& sudo tee $path/SLEEP/events &> /dev/null &
    sleep 2

    while [[ "$asleep" -eq 1 ]]; do
        asleep=$(cat $path/SLEEP/sleepstate)

        echo |& sudo tee $path/SLEEP/events &> /dev/null
        sleep 1
        events=$(wc -c < $path/SLEEP/events)
        #echo "$events"

       if [[ "$events" -gt 1 ]]; then
          echo "0" | sudo tee $path/SLEEP/sleepstate &> /dev/null
          asleep=$(cat $path/SLEEP/sleepstate)
          break
       fi
    done
    if (($playsound)); then
       ffplay -nodisp -loglevel quiet /home/pi/_files/samples/80s-logo08.mp3 &
    fi
}


while true; do
    filesize=$(wc -c < $path/SLEEP/evdump)
    totalsize=$(expr $filesize + $storedsize)

if [[ "$filesize" -gt 100000 ]]; then
    storedsize=$totalsize
    sleep 1
    sudo pkill evtest
    filesize=0
    echo " " |& sudo tee $path/SLEEP/evdump &> /dev/null
    sleep 2
    evtest /dev/input/event* |& sudo tee $path/SLEEP/evdump &> /dev/null &
fi

if [[ "$totalsize" == "$lastsize" ]]; then
    idlecount=$(($idlecount-1))
    #echo "IDLECOUNT: $idlecount"
else
    echo "event detected"
    idlecount=$timeout
    #echo "IDLECOUNT: $idlecount"
fi


if [[ "$idlecount" -eq 0 ]]; then
    echo "GOING INTO SLEEP MODE"
    sleep 1
    sudo python3 $path/SERIAL/reqTimeout2.py #&> /dev/null &
    sudo python3 $path/SERIAL/sleepSerial.py
    sleep 1
    timeout=$(cat $path/SLEEP/timeout)
    idlecount=$timeout
    eventListener &
    sudo python3 $path/SERIAL/waitWakeSerial.py
    echo "0" | sudo tee $path/SLEEP/sleepstate &> /dev/null
fi

if [[ "$idlecount" -eq 10 ]]; then
    echo "GOING TO SLEEP IN 10 SECONDS..."
fi

if [[ "$idlecount" -eq 5 ]]; then
    echo "GOING TO SLEEP IN 5 SECONDS..."
fi

    lastsize=$totalsize
    sleep 1

done
