#!/bin/bash

SCRIPT=$(readlink -f $0)
cafca_dir=$(dirname $SCRIPT)

log_dir='/home/pi/CAFCA/log'
log_file='/home/pi/CAFCA/log/CAFCA.log'

crt_log='/dev/shm/CRT_Launcher.log'
rc_log='/dev/shm/runcommand.log'
rc_info='/dev/shm/runcommand.info'

#________________________________________________________________________
#
# VARIABLES

args=("$@")
#args_len="$#"
action='DUMP'
mode='RUNCMD'

debug=1

retr_running=0
#retro_running=$(ps -ef | grep -v grep | grep retroarch)

#key_exit=0
#key_coin=0
#key_start=0


#________________________________________________________________________
#
# SETUP

#exec >> $log_file 2>&1
exec > >(sudo tee $log_file 2>&1)
sleep 1

echo -e "\nC A F C A\n"; echo -e `date "+%d/%m-%Y %T"` "\n\n"

if [ "${#args[@]}" -gt 0 ]; then
  echo -e "ARGS: \x27${args[@]}\x27 (n=${#args[@]})\n\n"
  action=$(echo "$1" | tr '[:lower:]' '[:upper:]')

  [ "${#args[@]}" -gt 1 ] && mode=$(echo "$2" | tr '[:lower:]' '[:upper:]')
else
  echo -e "NO ARGS\n\n" #args=("$@") #|| args=('none')
fi

echo -e "MODE:\t$mode\nACTION:\t$action\n\n"

system=$(awk 'NR==1' $rc_info);echo -e "SYSTEM: $system\n"
game=$(awk -F'/' 'NR==3 {print $NF}' $rc_info | cut -d. -f1);echo -e "GAME: $game\n"


exit


#while :; do sleep 1; done


#tail -f "$log_file" 2>/dev/null | grep -c -m1 -q --line-buffered "hiscore memory file" && echo -e "\n" &>/dev/null
#log_sys=$( "$retro_log" | awk -F'=|,' '{print $5}')
#echo -e "\nSYSTEM:$log_sys\n"
#echo -e "\n/dev/shm: \n"


#cat $crt_log | awk 'NR==1' | sudo tee "$log_file" &>/dev/null

#exec > $log_file 2>&1


#________________________________________________________________________
#
# MAIN SCRIPT

Main() {
   # FETCH INPUT CONFIGS
   (( $(cat "$config" | grep -c "exit_emulator") )) && key_exit=$(cat "$config" | grep exit_emulator | awk -F'\x22' '{print $2}');debug "EXIT KEY: $key_exit"
   (( $(cat "$config" | grep -c "player1_select ") )) && key_coin=$(cat "$config" | grep "player1_select " | awk -F'\x22' '{print $2}');debug "COIN KEY: $key_coin"
   (( $(cat "$config" | grep -c "player1_start ") )) && key_start=$(cat "$config" | grep "player1_start " | awk -F'\x22' '{print $2}');debug "START KEY: $key_start\n"

   # LAUNCH GAME
   "$retroarch" -L "$mame_core" --config "$config" "$game_path/$game.zip" --log-file "$log_file" --verbose 2>&1 &>/dev/null &
   sleep 2

   # WAIT FOR GAME TO FULLY LOAD
   tail -f "$log_file" 2>/dev/null | grep -c -m1 -q --line-buffered "hiscore memory file" && echo -e "\n" &>/dev/null
   debug "READY!\n"
   sleep 2

   # CLONE LOG-FILE
   sudo cp "$log_file" "$log_dir/log_copy.log"

   #_____________________________________________________________________
   #
   # GET GAME INFO:

   game_name=$(grep -m1 "lookup name:" "$log_dir/log_copy.log" | awk -F' ' '{print $8}')

   game_info=$(cat "$log_dir/log_copy.log" | grep -n --line-buffered "GAMEINFO:")
   info_count=$(echo -e "$game_info" | wc -l)
   if [[ "$info_count" -gt 1 ]]; then
      title_line=$(echo -e "$game_info" | awk NR==2 | awk -F':' '{print $1}')
      add_info_line=$(( title_line + 1 ))
      debug "$info_count occurences of title.\n"

      game_title=$(awk NR=="$title_line" "$log_dir/log_copy.log" | awk -F':' '{print substr($2, 2, length($2))}')
      game_title+=" ("
      game_title+=$(awk NR=="$add_info_line" "$log_dir/log_copy.log")
      game_title+=")"
   else
      game_title=$(echo -e "$game_info" | awk -F':' '{print $3}')
   fi
   debug "NAME: $game_name"
   debug "TITLE: $game_title\n"

   #_____________________________________________________________________
   #
   # GET REGION INFO:

   reg_offset='0x3bac4a' # grep in GAMES_TABLE
   reg_start=$(sudo scanmem -p `pidof retroarch` -c'dregions !2;lregions;exit' |& awk NR==16 | awk '{print "0x" substr($3, 0, length($3))}')
   reg_newbase=$(calculateNewBase "$reg_start" "$reg_offset")

   debug "REGION BASE: $reg_start"
   debug "OFFSET: $reg_offset"
   debug "NEW BASE: $reg_newbase"

   #_____________________________________________________________________
   #
   # LOOP:

   credits=0
   addr="$reg_newbase"
   while :;do
      clear
      echo -e "CREDITS: $credits"
      #credits_dump=$(sudo scanmem -p `pidof retroarch` -c"dump $addr;exit") #|& awk NR==16) #| awk '{print "0x" substr($3, 0, length($3))}')
      #echo "$credits_dump"
      sudo scanmem -p `pidof retroarch` -c"dump $addr 1;exit" |& awk -W interactive NR==15
      printf 'c' >/tmp/vkbdd.fifo
      sleep 5
      credits=$(( credits + 1 ))
   done

}


calculateNewBase() {
   args=("$@")
   [[ "${#args[*]}" -ne 2 ]] && return || BASE="$1"; OFFSET="$2"
   printf -v newaddr "0x%X\n" $(( BASE + OFFSET ));echo "$newaddr"
}

calculateOffset() {
   args=("$@")
   [[ "${#args[*]}" -ne 2 ]] && return || BASE="$1"; ADDR="$2"
   printf -v OFFSET "0x%X\n" $(( ADDR - BASE ));echo "OFFSET: $OFFSET"
}

scanCoin() {
   echo -e "`date`\n" | sudo tee SCANLOG.log &>/dev/null
   echo -e "`date`\n" | sudo tee SCANDUMP &>/dev/null

   while read -r line; do
      echo "$line" | grep -cq heap && echo "$line" | sudo tee -a SCANDUMP
      echo "$line" | grep -cq "> exit" && break
   done< <(tail -f SCANLOG.log) &

   sudo scanmem -p `pidof retroarch` -c'option region_scan_level 1;reset' |& sudo tee -a SCANLOG.log #&  #2>&1
   scanmem_pid=$!
}

press_key() {
  key="$@"
  printf "$key" > /tmp/vkbdd.fifo
}

debug() {
   if (( "$debug"  )); then
      msg="$@"
      #msg=$1
      echo -e "[DEBUG] $msg"
   fi
}


cleanup() {
  debug "Cleaning up..."
  [ "$retroarch_running" ] && printf 'e' >/tmp/vkbdd.fifo #sudo pkill retroarch
  sleep 2
  [ "$retroarch_running" ] && sudo pkill retroarch
  sudo pkill tail

  sudo cp "$log_file" "$cafca_dir/.bak/retroarch.log.bak"
  echo -e "\n" | sudo tee "$log_file" &>/dev/null
  sudo rm "$cafca_dir"/*.lpl &>/dev/null

}

trap cleanup EXIT

#Main
