#!/bin/bash

proc_name='SLEEP'
pid_num=$(ps -ef | grep -v grep | grep -i "$proc_name" | awk 'NR==1 {print $2}')

/usr/bin/expect -c '
  set timeout -1
  set ready 0

  # log
  log_user 1
  set log_path "./expect.log"
  exec echo -e "\n" > "$log_path"
  log_file "$log_path"

  # clear screen
  send "\033c"

  send_user "Expect Starting..\n\n"
  exec sleep 1

  # scanmem
  set pid [exec ps -ef | grep -v grep | grep -i SLEEP | awk "NR==1 {print \$2}"]
  spawn scanmem -p "$pid"

  set timeout 1

  expect {
    "matches." {
      #set ready 1
      send_user "MATCHES STR!\n"
      exp_continue
    }
    "Please" {
      #set ready 1
      #send_user "LOADED!\n"
      #exec sleep 1
      #send "0\r"
      send "option region_scan_level 3\r"
      send "reset\r"
      set ready 1
      exp_continue
    }
    ">" {
      if {$ready > 0} {
        send "\r"
        exec sleep 1
      }
      exp_continue
    }
  }
  expect eof
'
exit 0

####################################################

  #if {$ready < 1} {
  #  send_user "!ready.\n\n"
  #  exec sleep 1
  #  expect "Please" {
  #    set ready 1
  #    send_user "READY!\n"
  #    exec sleep 1
  #    send "lregions\r"
  #    exec sleep 1
  #    #exp_continue
  #  }
  #} else {
  #  while {flag < 1} {
  #    send_user "waiting."
  #    set timeout 1
  #    expect ">" {
  #      send_user "EXITING!"
  #      exec sleep 2
  #      send "exit\r"
  #    }
  #  }
  #}
  #exp_continue
  #expect eof

  #while { $ready < 1 } {
  #  expect "Please" {
  #    set flag 1
  #    send_user "FLAG TRUE!\n"
  #    exec sleep 1
  #    #send "lregions\r"
  #    #expect "> " { send "exit\r" }
  #  }
  #} elseif {$ready == 1} {
  #}
  #if {$flag < 1} {
  #  send_user "!FLAG"
  #  exp_continue
  #} else {
  #  send_user "FLAG TRUE!"
  #  send "exit\r"
  #}

  #interact
  #close
  #expect eof
#'

#exit 0








#clear screen
send "\033c"

send_user "\nSFTP uploader for dogenigt@data.dogenigt.dk\n\n"
sleep 1

log_user 0
set timeout -1
set quick 0
set arguments [lindex $argv]
set arguments_len [llength $arguments]
set file_len 0
set encrypted "YTJKY3V6S05hNjdOV1U5NlZKeGEK"
set pw [exec echo "$encrypted" | base64 -d]

set folder "pi"
set file ""
set input_file ""

if {$arguments_len > 0} {
  if {$arguments_len == 1} {
    set file [lindex $argv 0]
    set file_len [string length $file]
    send_user "Only $arguments_len arg was provided.\n"
    sleep 1
    send_user "Folder: $folder\n"
    send_user "File: $file\n"


  } elseif {$arguments_len > 1} {
    set folder [lindex $argv 0]
    set file [lindex $argv 1]
    set file_len [string length $file]
    send_user "$arguments_len args were provided.\n\n"
    send_user "Folder: $folder\n"
    send_user "File: $file\n"

    if {$arguments_len == 3} {
      set third_arg [lindex $argv 2]
      if {[string equal $third_arg "quick"]} {
        send_user "FLAG: quick\n"
        set quick 1
      }
    }
  }

} else {
  send_user "No arguments were provided.\nWill prompt for filename.\n\n"
  send_user "Folder: $folder\n"
}
send_user "\n"
sleep 2

###############################

proc quick_mode {} {
  send_user "Quick Mode\n"
  spawn sftp dogenigt@data.dogenigt.dk
  expect "password:"
    send "$pw\r"
  expect "sftp>"
    send "cd public_html_data.dogenigt.dk\r"
  expect "sftp>"
    send "cd pi\r"

  expect "sftp>"
    set status [catch {exec /usr/bin/find "$input_file" -type f} output]
    if {$status > 0} {
      send_user "ERROR: file not found\n"
      return
    } else {
      send_user "Uploading file: $input_file\n"    
      send "put $input_file\r"
    }
}

if {$quick == 1} {
  quick_mode
}

#####################################
#            BEGIN                  #
#####################################

spawn sftp dogenigt@data.dogenigt.dk
send_user "Starting SFTP\n"
sleep 1

expect "password:"
  send "$pw\r"

expect "sftp>"
  send_user "Logged in!\n\n"
  sleep 1
  send "cd public_html_data.dogenigt.dk\r"

expect "sftp>"
  send "cd $folder\r"

expect "sftp>"
  if {$file_len > 0} {
    set input_file "$file"

  } else {
    send_user "Please enter filename: "

    expect_user -re "(.*)\n" {
      set input_file $expect_out(1,string)
    }
  }

  if {[string trim $input_file] eq ""} {
    send_user "ERROR: no filename provided.\n\n"
    sleep 1
    return

  } else {
    set status [catch {exec /usr/bin/find "$input_file" -type f} output]

    if {$status > 0} {
      send_user "ERROR: file not found\n"
      sleep 1
      return
    } else {
      sleep 1    
      send "put $input_file\r"
      log_user 1
      }
    }

sleep 1

expect "sftp>"
#sleep 1
send "quit\r"

send_user "DONE!\n\n"
#sleep 1
close
#expect eof
#interact
