#!/usr/bin/env python3 -*- coding: utf-8

import serial
import os
import sys
from time import sleep

#__________________________________________________

debug = 1

def send_msg():
    success = 0
    count = 0

    if os.path.exists(serial_port):
        if debug:
            print("\nFound serial port",serial_port,"!\n")

        with serial.Serial(serial_port, 9600, timeout=timeout) as arduino:
            try:
                sleep(0.1)

                if arduino.isOpen():
                    arduino.reset_input_buffer()
                    print(f"writing '{msg}' to {serial_port}..")
                    arduino.write(msg.encode())
                    sleep(0.1)

                    if int(wait) > 0:
                        print("waiting for response..")
                        while count < timeout:
                            try:
                                if arduino.inWaiting()==0:
                                    sleep(1)
                                    count = count+1
                                elif arduino.inWaiting() > 0:
                                    while arduino.inWaiting()>0:
                                        line = arduino.readline().decode('utf-8').strip()
                                        print("\nReceived: \x27"+line+"\x27\n\n")
                                        sleep(0.1)
                                        arduino.flushInput()
                                        success = 1
                                        os._exit(1)
                                    break
                            except serial.SerialException as se:
                                print("Serial port error:",se)
                                break
                    arduino.close()

            except Exception as e:
                print(f"Error opening Arduino:",e)

            except KeyboardInterrupt:
                print("KeyboardInterrupt has been caught.")
                arduino.close()
                os._exit(1)
    else:
        print(f"Waiting for {serial_port}...")
        sleep(5)


#--------------------------------------------------

serial_port = '' # "/dev/ttyACM1"
timeout = 3
count = 0
msg = ''
port = 0
wait = 0
force = 0
success = 0

#arg_len = (len(sys.argv)-1)
arg_len = len(sys.argv)
print("ARGS:",arg_len,sys.argv)

try:
    if arg_len > 1:
        msg = sys.argv[1]+";"

        if arg_len > 2:
            if sys.argv[2].strip().isdigit():
                port = sys.argv[2].strip()

        if arg_len > 3:
            if sys.argv[3].strip().isdigit():
                wait = sys.argv[3].strip()

        if arg_len > 4:
            if sys.argv[4].strip().isdigit():
                force = sys.argv[4].strip()

        if arg_len > 5:
            if sys.argv[5].strip().isdigit():
                timeout = int(sys.argv[5].strip())

        dev_found = int(os.popen('[ -c /dev/ttyACM'+port+' ] && echo 1 || echo 0').read().strip())

        print("\n\n")
        print(f"msg:       '{msg}'")
        print(f"port:      '{port}'")
        print(f"wait:      '{wait}'")
        print(f"force:     '{force}'")
        print(f"timeout:   '{timeout}'")
        print(f"dev_found: '{dev_found}'")
        print("\n\n")

        if dev_found > 0:
            serial_port = '/dev/ttyACM'+port
            send_msg()

            if (int(force) > 0) and (success < 1):
                while success < 1:
                    send_msg()

                os._exit(1)

except Exception as e:
    print(f"Error: {e}")


os._exit(1)

#while True:
#    loop()
#    #sleep(1)

#fifo.close()
#sys.exit()
