#!/bin/bash

log_file='/home/pi/ADMIN/CMD/.TST/grep_mult_array.log'
test_output='/home/pi/ADMIN/CMD/.TST/grep_mult_array.out'
words=('SET_GEOMETRY' 'hiscore memory file' 'Git Version')

clear
#echo -e "words: \n${words[*]}"

str=''

log_len=$(cat $log_file | wc -l)
last_len=0

row_limit=$(( $log_len / 10 ))
repeat_limit=25
repeats=0

echo -e "" | sudo tee $test_output

#-----------------------------------------------------


for (( i=1;i<10000;i++ ));do
 #if [[ $i -lt $log_len ]]; then
 if [[ $i -lt $row_limit ]]; then
   line=$(awk -v row="$num" 'NR==row {print row": "$1" "$2" "$3" "$4" "$5" "$6}' $log_file)
   echo -e "$line" | sudo tee -a $test_output &>/dev/null
 fi

 out_len=$(cat $test_output | wc -l)

 if [[ $out_len == $last_len ]]; then
    repeats=$(( repeats + 1 ))
    [[ $repeats -gt $repeat_limit ]] && break
 fi

 echo -e "$i out_len: $out_len, repeats: $repeats"

 last_len=$out_len

 sleep 0.01

done

sleep 2
clear

exit 1

#-----------------------------------------------------

for (( i=0; i<${#words[@]}; i++ )); do
  echo -e "word $i: ${words[$i]}"
  str+="${words[$i]}"
  [[ $i < $(( ${#words[@]} - 1 )) ]] && str+="|"
done
echo -e "\n\nstr: \n$str"

#grep -E "${words[0]}|${words[1]}" "$log_file"
#grep -E "${words[@]}" "$log_file"
grep -E "$str" "$log_file"
grep -Ec -m1 "$str" "$log_file"

sleep 2
clear

#-----------------------------------------------------

for (( i=1;i<10000;i++ ));do
 if [[ $i -ge $log_len ]]; then
   num=$log_len
 else
   num=$i
 fi
 line=$(awk -v row="$num" 'NR==row {print row": "$1" "$2" "$3" "$4" "$5" "$6}' $log_file)
 echo -e "$line"
 sleep 0.01
done

sleep 2
clear


#-----------------------------------------------------

for (( i=1;i<$log_len;i++ ));do
  line=$(awk -v row="$i" 'NR==row {print row": "$1" "$2" "$3" "$4" "$5" "$6}' $log_file)
  echo -e "line $line"
  last_row=$i
done

sleep 2
clear
