#!/bin/bash

#clear
echo -e "$PWD:\n"
count=$(ls -l | awk 'NR==1 {print $0"\n"}')
find -maxdepth 1 \! -type l -exec ls -dla --group-directories-first {} + \
| awk '{
  fname=$9;
  sub(".\\/","",fname);
  hidden=substr(fname,0,2);

  user=$3
  perms=substr($1,2,length($1));

  type=substr($1,0,2);
  #type=(type == "d" ? "D" : (hidden == "." ? hidden : type));
  type=(type == "d" ? "D" : (hidden == "." ? hidden : type));
  type == "D" ? fname=fname "/" : fname=fname
  unit="B";
  size=$5;

  if (size >= 1024 * 1024) {
    size /= (1024 * 1024);
    unit="M"
  } else if (size >= 1024) {
    size /= 1024;
    unit="K"
  }

  date_str = $6" "$7" "$8;
  cmd = "date -d \"" date_str "\" +%m-%d\ %R";
  cmd | getline date_formatted;
  close(cmd);
  #print date_formatted;

  if (NR > 1) {
    printf "%s %6.1f%s %s %s %s\n", type, size, unit, user, date_formatted, fname
  }
}'
