#!/bin/bash

declare -A array=()
declare -a names=()

file=$(cat ./testfile)

#____________________________

echo -e "LINES:\n"

while read -r line; do
   name=$(echo "$line" | awk '{print $3}')
   names_str+="$name\n"
   echo -e "$line"
done< <(echo "$file")

echo -e "\n#___________________________________\n"

#____________________________

names=($(echo -e "$names_str" | sort | uniq))
echo -e "Names (${#names[@]}): ${names[@]}"

for (( i=0; i<${#names[@]}; i++ )); do
  echo -e "\n--------------\n"

  arr_name="${names[$i]}"
  eval "sub_arr=(\"\${$arr_name[@]}\")"

  while read -r line; do
    name=$(echo "$line" | awk '{print $3}')
    if [[ "$name" == "$arr_name" ]]; then
      sub_arr+=("$line;")
    fi
  done< <(echo "$file")

  nameUp=$(echo "$arr_name" | tr [a-z] [A-Z])
  array["$nameUp"]="${sub_arr[@]}"

  echo -e "$arr_name[@]: \x22${sub_arr[@]}\x22"

done
echo -e "\n#___________________________________\n\n"

#____________________________

echo -e "DICT:\n"

for key in "${!array[@]}"; do
  array_line=$(echo "${array[$key]}" | awk 'BEGIN{RS=";"}{$1=$1}1')
  lines=$(echo "$array_line" | wc -l)
  thisArr=()

  echo -e "\${array[$key]}=("
  echo -e "  \x22${array[$key]}\x22\n)"
  echo -e "\nlines:"

  for (( i=1; i<=$lines; i++ )); do
    line=$(echo "$array_line" | awk -v ln="$i" 'NR==ln')
    thisArr+=("$line")
    echo -e "$i: $line"
  done

  echo -e "\n"

  thisArr_len="${#thisArr[@]}"
  for (( i=0; i<thisArr_len; i++ )); do
    echo -e "\${thisArr[$i]}: \x22${thisArr[$i]}\x22"
  done
  echo -e "\nlength: $thisArr_len\n"
  echo -e "______________\n"
done

