#!/bin/bash
printf "\n"

shopt -s lastpipe
for src in arm core emmc uart v3d pixel h264 isp pwm vec hdmi dpi ; do
   echo -e "$src: $(vcgencmd measure_clock $src)" | \
   awk -v OFS=\n -F':|=' '{
     name = $1;
     val = $3;
     cmd = "echo \"" val "\" | sed \x27s/./&./4\x27";
     cmd | getline val_form;
     close(cmd);
     #unit = "Khz";
     #print unit;
     if (val >= 1000 * 1000) {
       val /= (1000 * 1000);
       unit = "Mhz";
     } else if (val >= 1000) {
       val /= 1000;
       unit = "Khz";
     } else {
       val = val;
       unit = " hz";
     }
     printf "%s\t%8.2f\n", name, val_form
     #printf "%s\t%2.2f %s\n", name, val, unit

   }'
done





