#!/usr/bin/env python3 -*- coding: utf-8

import serial
import os
import sys
from time import sleep

#__________________________________________________

serial_port = "/dev/ttyACM1"


def loop():

    if os.path.exists(serial_port):
        print("Found serial port",serial_port,"!")
        sleep(1)

        #with serial.Serial('/dev/ttyACM1', 9600, timeout=1) as arduino:
        with serial.Serial(serial_port, 9600, timeout=1) as arduino:
            try:
                sleep(0.1)

                if arduino.isOpen():
                    arduino.reset_input_buffer()

                    while True:
                        try:
                            if arduino.inWaiting()==0:
                                #sleep(1)
                                #count = count+1
                                msg = "HELLO GUN\n"
                                arduino.write(msg.encode())

                            elif arduino.inWaiting()>0:
                                while arduino.inWaiting()>0:
                                    line = arduino.readline().decode('utf-8').strip()
                                    print("\nReceived: \x27"+line+"\x27\n\n")

                                    #nom = line.split()[0]
                                    sleep(0.1)
                                    arduino.flushInput()
                                #sleep(1)
                                break
                        except serial.SerialException as se:
                            print("Serial port error:",se)
                            break

            except Exception as e:
                print(f"Error opening Arduino:",e)

            except KeyboardInterrupt:
                print("KeyboardInterrupt has been caught.")
                arduino.close()
                os._exit(1)
    else:
        print(f"Waiting for {serial_port}...")
        sleep(5)


#--------------------------------------------------

count = 0
loop()

#while True:
#    loop()
#    #sleep(1)

#fifo.close()
#arduino.close()
#sys.exit()
