#!/bin/bash

debug=0

admin_dir="/home/pi/ADMIN"
settings="$admin_dir/.sys/.settings"
states="$admin_dir/.sys/.states"
dump_file="/tmp/evdump"
sys_state=''
thd_cmd=''
thd_id=0

timeout=300
devices_found=0
count=0
asleep=0
last_len=0

proc_thd=
proc_dump=

#___________________________________________________

echo '' | sudo tee "$dump_file" &> /dev/null && sleep 0.5
sudo chmod 775 "$dump_file" && sleep 0.5

if [[ $(grep timeout_sys_default $settings | cut -d= -f2) -gt 0 ]]; then
  timeout=$(cat /boot/cmdline.txt | awk 'BEGIN{RS=" "}{$1=$1}1' | grep consoleblank | cut -d= -f2)
else
  timeout=$(grep -w timeout $settings | cut -d= -f2)
fi

echo -e "timeout: $timeout\n"

#----------------------------------------------------

function get_inputs() {

 devices=( \
   'usb-Lite-On_Technology_Corp._USB_Multimedia_Keyboard-event-kbd' \
   'usb-SHANWAN_Skyuan_F16-event-joystick' \
   'usb-Teensyduino_Serial_Keyboard_Mouse_Joystick_1008140-if02-event-kbd' \
 )

 thd_cmd='thd --dump '

 for device in "${devices[@]}"; do
   if [ -c "/dev/input/by-id/$device" ]; then
     thd_cmd+="/dev/input/by-id/$device "
     devices_found=1
   fi
 done
}

function dump() {
  len=$(cat "$dump_file" | wc -l)

  [ "$len" -gt 100 ] && echo '' | sudo tee "$dump_file"

  if [[ $len == $last_len ]]; then
    if (( ! $asleep )); then
      count=$(( count + 1 ))
      [[ $debug -gt 0 ]] && echo -e "count: $count"
    fi
    if (( "$count" > "$timeout" )); then
      echo "TIMEOUT!"
      asleep=1
      count=0
      printf "ASLEEP 1" > /tmp/pyserial.fifo
      sudo sed -i '/ASLEEP/ s/ASLEEP=0/ASLEEP=1/' "$states"
      #sed -i '/ASLEEP/d' "$states" && sleep 0.5
      #echo "BOOL ASLEEP 1" | sudo tee -a "$states" &> /dev/null &
    fi
  else
    if [[ $asleep > 0 ]]; then
      printf "ASLEEP 0" > /tmp/pyserial.fifo
      sudo sed -i '/ASLEEP/ s/ASLEEP=1/ASLEEP=0/' "$states"
      #sed -i '/ASLEEP/d' "$states"
      #echo "BOOL ASLEEP 0" | sudo tee -a "$states" &> /dev/null &
      asleep=0
    fi
    count=0
  fi

  last_len=$len
  sleep 1
}

# ----------------------------------------------------

function dump_input() {
  while true; do
    if [[ ! $sys_state == RA ]]; then
      (eval "$thd_cmd" |& sudo tee "$dump_file" &> /dev/null) &
      thd_id=$!
      echo "thd_id: $thd_id"
      while [[ ! $sys_state == RA ]]; do
        sys_state=$(grep UI "$states" | cut -d= -f2)
      done
      echo "[ SLEEP.sh ] sys_state == 'RA'"
    else
      sudo kill 9 $thd_id && sleep 5

      while [[ $sys_state == RA ]]; do
        sys_state=$(grep UI "$states" | cut -d= -f2)
        #echo "sys_state: $sys_state"
        sleep 1
      done

      echo "[ SLEEP.sh ] sys_state changed back!"
      sleep 5
    fi
  done
}

function thdKill() {
  sudo kill -9 $thd_id
}

trap 'thdKill' EXIT SIGINT INT

get_inputs
sys_state=$(grep UI "$states" | cut -d= -f2)

if [[ $devices_found -gt 0 ]]; then
  dump_input &
  while true; do
    sys_state=$(grep UI "$states" | cut -d= -f2)
    [[ ! $sys_state == "RA" ]] && dump
  done
fi

exit

