#!/bin/bash

device='usb-SHANWAN_Skyuan_F16-event-joystick'

thd_id=0
states='/home/pi/ADMIN/.sys/.states'
sys_state=''

function cleanQuit() {
  sudo kill -9 $thd_id
}

sys_state=$(grep UI $states | cut -d= -f2)

while true; do
  if [[ ! $sys_state == RA ]]; then
    thd --dump "/dev/input/by-id/$device" &
    thd_id=$!
    echo "thd_id: $thd_id"
    while [[ ! $sys_state == RA ]]; do
      sys_state=$(grep UI $states | cut -d= -f2)
      #echo "sys_state: $sys_state"
      sleep 0.1
    done
  else
    echo "sys_state == RA!"
    sudo pkill $thd_id && sleep 2

    while [[ $sys_state == RA ]]; do
      sys_state=$(grep UI $states | cut -d= -f2)
      echo "sys_state: $sys_state"
      sleep 1
    done

    echo "sys_state changed back!"
    sleep 2
  fi
done

trap 'cleanQuit' EXIT SIGINT INT
