#!/bin/bash

cafca_dir='/home/pi/CAFCA'
log_file="$cafca_dir/log/GUN.log"
gun_serial_port='/dev/ttyACM1'
serial_script="$cafca_dir/cmd/serial_gun.py"

exec > >(sudo tee -a "$log_file" 2>&1)

[[ ${#} -lt 1 ]] && (echo "no args." && exit)

system="${1}"
game="${2}"
data_file="$cafca_dir/data/$system/games/$game/info.dat"

echo "data_file: $data_file"

if [ -c "$gun_serial_port" ]; then
  sudo python3 "$serial_script" "LOADED" "1" "1" |& sudo tee -a "$log_file" 2>&1
  sleep 1
  if [ -f "$data_file" ]; then
    while read line; do
      key=$(echo "$line" | cut -d' ' -f1 | cut -d'_' -f2)
      val=$(echo "$line" | cut -d' ' -f2-)
      echo "$key $val"
      (sudo python3 -u "$serial_script" "$key $val" "1" |& sudo tee -a "$log_file" 2>&1 ) && sleep 1
    done< <(cat "$data_file" | awk 'NR > 2')
    echo "done!"
  fi
fi

while [[ $(ps -ef | grep -v grep | grep -m1 -c retroarch) -gt 0 ]]; do
  #echo "PING"
  sleep 1
done

#(sudo python3 -u "$serial_script" "UNLOAD" "1" "1" |& sudo tee -a "$log_file" 2>&1 ) &

exit

