#!/bin/bash

cafca_log='/home/pi/CAFCA/log/CAFCA.log'
system=$(cat /dev/shm/runcommand.info | awk 'NR==1')
game=$(cat /dev/shm/runcommand.info | awk -F/ 'NR==3 {print $NF}' | cut -d. -f1)

timeout=5

exec > >(sudo tee -a "$cafca_log" 2>&1)
echo "RUNCMD END:"

printf "GAME_STOPPED 1" > /tmp/pyserial.fifo

#[ -c /dev/ttyACM1 ] && (sudo python3 /home/pi/CAFCA/cmd/serial_gun.py "UNLOAD" "1") &

while [[ $timeout -gt 0 ]]; do
  if [[ $(grep -c GAME_LOADED "/home/pi/CAFCA/data/.states" | cut -d= -f2) -lt 1 ]]; then
    echo "  SAW GAME_LOADED !1 in cafca states file"
    break
  fi
  timeout=$(( timeout - 1 ))
done

if [[ $(ps -ef | grep -v grep | grep -i -c "CAFCA") > 0 ]]; then
  while read -r line; do
    echo "  killing proc $line ($(ps -ef | grep -v grep | grep -m1 $line | awk '{$1=$1;print}' | cut -d' ' -f8-))"
    sudo kill -9 "$line";
  done< <(ps -ef | grep -v grep | grep -i "CAFCA" | awk '{print $2}')
fi

if [[ "$system" == mame-libretro ]]; then
  path=$(cat /dev/shm/runcommand.info | awk 'NR==3' | rev | cut -d/ -f2- | rev)
  [ -f "$path/mame2003/nvram/$game.nv" ] && sudo rm "$path/mame2003/nvram/$game.nv"
fi

#if [[ $(grep GAME_TYPE "/home/pi/CAFCA/data/.states" | cut -d= -f2) == GUN  ]]; then
#  [ -c /dev/ttyACM1 ] && (sudo python3 /home/pi/CAFCA/cmd/serial_gun.py "UNLOAD" "1" "1") &
#fi

sudo cp -f "/home/pi/CAFCA/data/.states.default" "/home/pi/CAFCA/data/.states"
sudo sed -i '/UI/d' /home/pi/ADMIN/.sys/.states && sleep 1
echo "VAR UI=ES" | sudo tee -a /home/pi/ADMIN/.sys/.states &>/dev/null

sleep 1

exit
