#!/bin/bash

/usr/bin/expect -c '
  log_user 1
  exp_internal 0

  set timeout -1

  set log_path "/home/pi/CAFCA/log/expect.log"
  set busy_flag "/home/pi/CAFCA/data/scan_flag"
  set coin_file "/home/pi/CAFCA/data/tmp/cafca_coins_cnt"
  set coin_count 0

  #set pid [exec pidof retroarch]
  set pid 734

  set ready 0
  set scanned 0
  set matched 0
  set matches 999
  set match_limit 3

  set credits 0
  set last_credits 0

  # clear screen
  send "\033c"

  exec echo -e "\n" > "$log_path"
  log_file "$log_path"
  #exec echo "PID: $pid"
  exec echo "0" > "/home/pi/CAFCA/data/scan_flag"
  spawn scanmem -p $pid

  expect {
    "matches." {
      exec sleep 1
      if {$scanned == 0} {
        set scanned 1
      }
        while {$credits == $last_credits} {
          set credits [exec cat "$coin_file"]
        }
        exec sleep 1
        send "$credits\r"
        send_user "credits: $credits\n"
      exp_continue
    }

    "Please" {
      if {$ready == 0} {
        send "option region_scan_level 3\r"
        send "reset\r"
        set ready 1
      }
      exp_continue
    }

    "*>" {
      if {$ready > 0} {
        set output [lindex [split [lindex [split $expect_out(0,string) "\n"] 1] ">" ] 0]
        #set coin_count [exec cat "$coin_file"]

        if {$scanned > 0} {
          set matches $output
          #send_user "matches: $matches\n"
        }
        if {$matches > $match_limit} {
          set credits [exec cat "$coin_file"]
          #send_user "credits: $credits\n"

          if {$credits > 0} {
            if {$credits != $last_credits} {
              exec echo "1" > "/home/pi/CAFCA/data/scan_flag"
              exec sleep 1
              send "$credits\r"
              set last_credits $credits
              send_user "last_credits: $last_credits\n"

              #while {$credits == $last_credits} {
              #  set credits [exec cat "$coin_file"]
              #  exec sleep 1
              #  send "$credits\r"
              ##  if {$credits != $last_credits} {
              ##    send_user "credits: $credits\n"
              ##  }
              #}
            }
          } else {
            while {$credits < 1} {
              set credits [exec cat "$coin_file"]
              exec sleep 1
              send_user "credits < 1\n"
            }
            send "$credits\r"
          }
          exec echo "0" > "/home/pi/CAFCA/data/scan_flag"
          exec sleep 1

        } else {
          if {$matches < 0} {
            send "list\r"
          }
        }
      }
      exp_continue
    }

    #set credits [exec cat "$coin_file"]
    #exec sleep 1
    #if {$credits != $last_credits} {
    #  exec sleep 2
    #  send "$credits\r"
    #  send_user "credits: $credits\n"
    #}

    #if {$credits > 0} {
    #  while {$credits == $last_credits} {
    #    set credits [exec cat "$coin_file"]
    #    if {$credits != $last_credits} {
    #      send "$credits\r"
    #      set last_credits $credits
    #      send_user "last_credits: $last_credits\n"
    #      exec sleep 1
    #    }
    #  }
    # exp_continue
    #}
  }
  expect eof
'
exit 0

####################################################

  #if {$ready < 1} {
  #  send_user "!ready.\n\n"
  #  exec sleep 1
  #  expect "Please" {
  #    set ready 1
  #    send_user "READY!\n"
  #    exec sleep 1
  #    send "lregions\r"
  #    exec sleep 1
  #    #exp_continue
  #  }
  #} else {
  #  while {flag < 1} {
  #    send_user "waiting."
  #    set timeout 1
  #    expect ">" {
  #      send_user "EXITING!"
  #      exec sleep 2
  #      send "exit\r"
  #    }
  #  }
  #}
  #exp_continue
  #expect eof

  #while { $ready < 1 } {
  #  expect "Please" {
  #    set flag 1
  #    send_user "FLAG TRUE!\n"
  #    exec sleep 1
  #    #send "lregions\r"
  #    #expect "> " { send "exit\r" }
  #  }
  #} elseif {$ready == 1} {
  #}
  #if {$flag < 1} {
  #  send_user "!FLAG"
  #  exp_continue
  #} else {
  #  send_user "FLAG TRUE!"
  #  send "exit\r"
  #}

  #interact
  #close
  #expect eof
#'

#exit 0








#clear screen
send "\033c"

send_user "\nSFTP uploader for dogenigt@data.dogenigt.dk\n\n"
sleep 1

log_user 0
set timeout -1
set quick 0
set arguments [lindex $argv]
set arguments_len [llength $arguments]
set file_len 0
set encrypted "YTJKY3V6S05hNjdOV1U5NlZKeGEK"
set pw [exec echo "$encrypted" | base64 -d]

set folder "pi"
set file ""
set input_file ""

if {$arguments_len > 0} {
  if {$arguments_len == 1} {
    set file [lindex $argv 0]
    set file_len [string length $file]
    send_user "Only $arguments_len arg was provided.\n"
    sleep 1
    send_user "Folder: $folder\n"
    send_user "File: $file\n"


  } elseif {$arguments_len > 1} {
    set folder [lindex $argv 0]
    set file [lindex $argv 1]
    set file_len [string length $file]
    send_user "$arguments_len args were provided.\n\n"
    send_user "Folder: $folder\n"
    send_user "File: $file\n"

    if {$arguments_len == 3} {
      set third_arg [lindex $argv 2]
      if {[string equal $third_arg "quick"]} {
        send_user "FLAG: quick\n"
        set quick 1
      }
    }
  }

} else {
  send_user "No arguments were provided.\nWill prompt for filename.\n\n"
  send_user "Folder: $folder\n"
}
send_user "\n"
sleep 2

###############################

proc quick_mode {} {
  send_user "Quick Mode\n"
  spawn sftp dogenigt@data.dogenigt.dk
  expect "password:"
    send "$pw\r"
  expect "sftp>"
    send "cd public_html_data.dogenigt.dk\r"
  expect "sftp>"
    send "cd pi\r"

  expect "sftp>"
    set status [catch {exec /usr/bin/find "$input_file" -type f} output]
    if {$status > 0} {
      send_user "ERROR: file not found\n"
      return
    } else {
      send_user "Uploading file: $input_file\n"    
      send "put $input_file\r"
    }
}

if {$quick == 1} {
  quick_mode
}

#####################################
#            BEGIN                  #
#####################################

spawn sftp dogenigt@data.dogenigt.dk
send_user "Starting SFTP\n"
sleep 1

expect "password:"
  send "$pw\r"

expect "sftp>"
  send_user "Logged in!\n\n"
  sleep 1
  send "cd public_html_data.dogenigt.dk\r"

expect "sftp>"
  send "cd $folder\r"

expect "sftp>"
  if {$file_len > 0} {
    set input_file "$file"

  } else {
    send_user "Please enter filename: "

    expect_user -re "(.*)\n" {
      set input_file $expect_out(1,string)
    }
  }

  if {[string trim $input_file] eq ""} {
    send_user "ERROR: no filename provided.\n\n"
    sleep 1
    return

  } else {
    set status [catch {exec /usr/bin/find "$input_file" -type f} output]

    if {$status > 0} {
      send_user "ERROR: file not found\n"
      sleep 1
      return
    } else {
      sleep 1    
      send "put $input_file\r"
      log_user 1
      }
    }

sleep 1

expect "sftp>"
#sleep 1
send "quit\r"

send_user "DONE!\n\n"
#sleep 1
close
#expect eof
#interact
