#!/bin/bash

aliasfile='/home/pi/.bash_aliases'
funcs=$(cat $aliasfile | grep -c "() {")

clear

declare -a rownums=()
declare -a names=()
declare -A entries=()

empty_row="                                                        "
tty_height=$(tput lines)

for ((i=1;i<=$funcs;i++)); do
  last_i=$((i - 1))
  grepstr=$(cat $aliasfile \
   | grep -m"$i" "() {" | tail -n -1)

  name=$(echo "$grepstr" | cut -d'(' -f1)
  names["$i"]="$name"

  rownum=$(cat $aliasfile | grep -w -n -m1 "$grepstr" | cut -d: -f1)
  rownums["$i"]="$rownum"

  if [ "$i" -gt 1 ]; then
    lastrow="${rownums[$last_i]}"
    rownums["$last_i"]="$lastrow $rownum"
    entries["${names[$last_i]}"]="${rownums[$last_i]}"
  fi

done

sleep 1

 while true; do
   clear
   echo -e "\n  ~/.bash_aliases functions:\n"
   echo -e "  ____________________________________________________\n\n"

   for i in "${!entries[@]}"; do
     val1=$(echo "${entries[$i]}" | cut -d' ' -f1)
     val2=$(echo "${entries[$i]}" | cut -d' ' -f2)
     printf "  %9s\t%4d %4d\n" "$i" "$val1" "$val2"
   done
   echo -e "\n"

   tput sc
   read -rp "  type entry: " entry

   if [[ -v entries[$entry] ]]; then
     range="${entries[$entry]}"
     start=$(echo "$range" | cut -d' ' -f1)
     end=$(  echo "$range" | cut -d' ' -f2)

     page=$(cat $aliasfile | \
      awk -v page_start="$start" -v page_end="$end" '{
       if (NR >= page_start && NR < page_end) {
        if (NR == page_start || NR > (page_end)-3) {
          print "  \033[36m"$0"\033[0m"}else{print "  "$0
        }
       }
      }')

     clear
     page_len=$(echo "$page" | wc -l)

     if [ "$page_len" -gt "$tty_height" ]; then
       echo "$page" | awk '{print $0}' | less -ERKX
     else
       echo "$page" | awk '{print $0}'
     fi

   else
     echo -e "\n  entry doesn't exist."
   fi

   echo -e "\n  press any key to return."
   read -srN1 dummy

   for ((r=17;r< "$(($(tput lines) - 2))";r++)); do
     tput cup $r 0
     echo "$empty_row"
   done
   tput rc
 done
