#!/bin/bash

HOMEDIR=$(getent passwd "$USER" | cut -d: -f6)
echo "HOMEDIR: $HOMEDIR"
echo -e "\n\$0:\t\t\t$0"
echo -e "readlink -f \$0:\t\t$(readlink -f $0)"
echo -e "dirname \$0:\t\t$(dirname $0)"
echo -e "BASH_SOURCE[0]:\t\t${BASH_SOURCE[0]}"
echo -e "rl -f \$BASH_SOURCE:\t$(readlink -f ${BASH_SOURCE[0]})"

# SAFEST?
DIR=$(dirname $(readlink -f "${BASH_SOURCE[0]}" 2>/dev/null||echo $0))
#echo -e "\nDIR: $DIR"

# MOST CORRECT
SRC=$(cd "$(dirname $0)" && pwd)
echo -e "\nSRC: ${SRC}"
#source "${SRC}/include.sh"

# ALTERNATE
SCRIPT=$(readlink -f "${BASH_SOURCE[0]}")
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
echo -e "\nDIR: $DIR"
source "${DIR}/include.sh"


