#!/bin/bash
clear

gamelist=/home/pi/CAFCA/data/.gamelist

page_size=$(( $(tput lines) - 5 ))
pages_read=0
entries=$(cat $gamelist | wc -l)

echo "page_size: $page_size" && sleep 2

echo -e "ENTRIES: $entries\n"
  while read -rsn1 input; do
    limit=$(( entries - pages_read ))
    clear && echo -e "offset: $limit\n" && sleep 1

    case "$input"
    in
      $'\x1B')  # ESC ASCII code (https://dirask.com/posts/ASCII-Table-pJ3Y0j)
        break
        ;;
      $"") # ENTER
        pages_read=$(( pages_read + page_size ))
        cat $gamelist | tail -n $limit | head -n $page_size
        echo #echo -e "\n\n"
        ;;
    esac
  done
