#!/bin/bash

#include_file='/home/pi/ADMIN/include.sh'
#[ -f $include_file ] \
#&& source $include_file
#include

#declare -a options=( \
#"CAFCA=(CAFCA_SETUP[FIRST HELLO;SECOND PAT]:CAFCA_MAIN[CMD1 bash /home/pi/mycmd.sh;CMD2 ps -ef | grep something]) MC=(mc) MYTOOL=(RUN)" \
#"" \
#"" \
#)

declare -A array=( \
  [TOOLS]="CAFCA_SETUP[SCANCOIN echo PATSPA;GETADDR pip list]:CAFCA_MAIN[CMD1 bash /home/pi/mycmd.sh;CMD2 ps -ef | grep something]" \
  [SETUP]="VIDEO_MODE[SET_MODE fbset -xres 320 -yres 240]:"
)

#declare -a nav=()
#nav[0]='MAIN'
#navstring='MAIN >'
nav=''

main_selected=''
prevArr=()

Main() {
  #listArrays
  MainMenu
}

MainMenu() {
  nav='MAIN > '
  keys=()
  menulist=()
  count=0

  for key in "${!array[@]}"
  do
     keys+=("$key")
     menulist+=($(echo -e "$count $key"))
     count=$(( count + 1 ))
  done

  selected=$(whiptail --title "ADMIN MENU" --menu "$nav" 16 36 8 "${menulist[@]}" 3>&1 1>&2 2>&3)
  rc=$?
  main_selected="${keys[$selected]}"
  prevArr="$main_selected"
  nav+="$main_selected";nav+=" > "
  [ $rc -gt 0 ] && return || subMenu "$main_selected"

}

subMenu() {
       key=$1
       menulist=()
       subArray=()
       itemArray=()

       entry="${array[$key]}"
       entrySplit=$(echo "$entry" | awk -F: '{ for (i=1; i<=NF; i++) print $i }')
       entryCount=$(echo "$entrySplit" | wc -l)

       for ((i=0;i<$entryCount;++i)); do
         splitString=$(echo "$entrySplit" | awk -v line="$(( $i + 1 ))" 'NR==line')
         subKey=$(echo "$splitString" | awk -F'\\[|\\]' '{print $1}')
         subArray+=("$subKey")

         itemsString=$(echo "$splitString" | awk -F'\\[|\\]' '{print $2}')
         itemArray+=("$itemsString")
         menulist+=($(echo -e "$i $subKey"))
       done

       selected=$(whiptail --title "ADMIN MENU" --menu "$nav" 16 36 8 "${menulist[@]}" 3>&1 1>&2 2>&3)
       rc=$?

       sub_selected="${subArray[$selected]}"
       cmd_items="${itemArray[$sub_selected]}"

       [ $rc -gt 0 ] && MainMenu || nav+="${subArray[$selected]}";cmdMenu "$cmd_items"
}

cmdMenu() {
  menulist=()
  cmds=()

  items=$(echo "$@" | awk -F';' '{ for (i=1; i<=NF; i++) print $i }')
  itemCount=$(echo "$items" | wc -l)

  for ((c=0;c<$itemCount;++c)); do
    itemString=$(echo "$items" | awk -v line="$(( $c + 1 ))" 'NR==line')
    itemKey=$(echo "$itemString" | cut -d' ' -f1)
    itemVal=$(echo "$itemString" | cut -d' ' -f2-)
    cmds+=("$itemVal")
    menulist+=($(echo -e "$c $itemKey"))
  done

  selected=$(whiptail --title "ADMIN MENU" --menu "$nav" 16 36 8 "${menulist[@]}" 3>&1 1>&2 2>&3)
  rc=$?
  [ $rc -gt 0 ] && nav=$(echo "$nav" | cut -d'>' -f -2);subMenu "$main_selected" || eval "${cmds[$selected]}"
}

############################################################################

function listArrays() {

    for key in "${!array[@]}"
    do
       entry="${array[$key]}"
       entrySplit=$(echo "$entry" | awk -F: '{ for (i=1; i<=NF; i++) print $i }')
       entryCount=$(echo "$entrySplit" | wc -l)

       #echo -e "\nKEY: $key\n"
       #echo -e "ENTRY: $entry\n"
       echo -e "\${array[$key]}:"
       echo -e "declare -A array=\x22$entry\x22\n"
       echo -e "ENTRIES:\n\n$entrySplit"
       echo -e "_____________________________________\n"

       for ((i=0;i<$entryCount;++i)); do
         splitString=$(echo "$entrySplit" | awk -v line="$(( $i + 1 ))" 'NR==line')
         splitArrName=$(echo "$splitString" | awk -F'\\[|\\]' '{print $1}') #'{ for (i=2; i<=NF; i+=2) print $i }')
         splitItemsString=$(echo "$splitString" | awk -F'\\[|\\]' '{print $2}') #| awk -F; '{ for (i=1; i<=NF; i++) print $i }')
         splitItems=$(echo "$splitItemsString" | awk -F';' '{ for (i=1; i<=NF; i++) print $i }')
         splitItemCount=$(echo "$splitItems" | wc -l)

         echo -e "ENTRY $i:"
         echo -e "STR: \x27$splitString\x27\n"
         echo -e "NAME: \x27$splitArrName\x27"
         echo -e "LINE: \x27$splitItemsString\x27\n"
         echo -e "ITEMS:"
         #echo -e "\n$splitItems"

         for ((c=0;c<$splitItemCount;++c)); do
           itemString=$(echo "$splitItems" | awk -v line="$(( $c + 1 ))" 'NR==line')
           itemKey=$(echo "$itemString" | cut -d' ' -f1)
           itemVal=$(echo "$itemString" | cut -d' ' -f2-)

           echo -e "\n$c ($itemString):"
           echo -e "KEY: $itemKey\nVAL: $itemVal\n-------"

         done
         echo -e "_____________________________________\n"
       done
    done
}

#listArrays
Main
exit








#####################################################################################################


#declare -a KEYS=(FNAME LNAME)
#declare -A PERSON='([FNAME]="John" [LNAME]="Andrew" )'
#for key in ${KEYS[@]}; { echo $key ${PERSON[$key]}; }


#itemVal=$(echo "$itemString" | awk -F' ' '{ for (i=2; i<=NF; i++) printf "%s%s", (i > 2 ? OFS : ""), $i; printf "\n" }') #| awk -F' ' '{ for (i=2; i<=NF; i++) print $i }')

#readarray -t my_array < <(awk -F, '{ for (i=1; i<=NF; i++) print $i }' data.txt)

#declare -A subArr=()

#declare -a sys_video=("0 SELECT_VIDEO_MODE; bash /home/pi/pat.sh")
#declare -a sys_video_mode=()

#declare -a sys_video_mode+=( \
#  "SELECT_VIDEO_MODE; bash /home/pi/pat.sh" \
#  "SOMETHING_ELSE; run myprogram.exe" \
#)

#   showMenu "${!mainArr[@]}"
#
#   while true; do
#     [ ${#returnArr[@]} -gt 0 ] && showMenu "${returnArr[@]}" || break
#     #echo -e "user selected $resultKey\n"
#   done

  #declare -a setupArr=("CAFCA_SETUP[0 HELLO;1 PAT]:CAFCA_MAIN[0 RUN;1 TEST]")
  #declare -a systemArr=("VIDEO_MODE")
  #declare -a toolsArr=('MC')
  #declare -a gamesArr=($(cat /home/pi/CAFCA/GAMELIST))

  #declare -A array=( \
  #  [SYSTEM]="CAFCA_SETUP[0 HELLO;1 PAT]:CAFCA_MAIN[0 RUN;1 TEST]" \
    #[TOOLS]="MC[0 HELLO;1 PAT]" \
    #[SYSTEM]="${systemArr[@]}" \
    #[SETUP]="${setupArr[@]}" \
    #[TOOLS]="${toolsArr[@]}" \
    #[GAMES]="${gamesArr[@]}" \
  #)

  #declare -A subArray=()

function showMenu() {
    returnArr=()
    newArr=()
    choices=()
    array=(${@})
    count=0

    for key in "${!array[@]}"
    do
       choices+=($(echo -e "$count ${array[$key]}")) &>/dev/null
       count=$(( count + 1 ))
    done

    result=$(whiptail --title "ADMIN MENU" --menu "$navstring" 16 36 8 "${choices[@]}" 3>&1 1>&2 2>&3)
    rc=$?

    quit_true=0
    if [ $rc -gt 0 ]; then
      nav["$level"]=''
      navstring=$(echo "${nav[*]}" | sed 's/ / > /g')
      if [ $level -gt 0 ]; then
        [ ${#prevArr[@]} -gt 0 ] && newArr=("${prevArr[@]}") || quit_true=1
        level=$((level - 1))
      else quit_true=1
      fi
    else
      prevArr=("${array[@]}")
      resultKey="${array[$result]}"
      newArr=($(echo -n "${mainArr[$resultKey]}"))
      #whiptail --title "Option 1" --msgbox "You chose option $result ($resultKey). \nExit status $?" 8 45
      level=$((level + 1))
      nav["$level"]="$resultKey"
      navstring=$(echo "${nav[*]}" | sed 's/ / > /g')
    fi

    [ $quit_true -gt 0 ] && exit

    returnArr=("${newArr[@]}")
    if [ ${#returnArr[@]} -lt 1 ]; then
      runCommand "$resultKey"
      nav=();nav[0]='MAIN'
      navstring='MAIN >'
      level=0
      showMenu "${!mainArr[@]}"
      #return
    fi
}

showSubMenu() {
  choices=()
  count=0
  arr_name=$(echo "$1_$2" | tr [A-Z] [a-z])

  #echo -e "\narr_name: $arr_name"
  eval "sub_arr=(\"\${$arr_name[@]}\")"

  for key in "${!sub_arr[@]}"; do
    str="${sub_arr[$key]}"
    entry=$(echo "$str" | cut -d';' -f1)
    #entry=$(echo -e "\x22$entry\x22")
    cmd=$(echo "$str" | cut -d';' -f2)
    #echo -e "\nsys_video\n-str: $str\n-entry: $entry\n-cmd: $cmd"
    subArr["$entry"]="$cmd"
  done

  #echo -e "\nSUBARR KEYS: ${!subArr[@]}\n"
  #echo -e "\nSUBARR VALS: ${subArr[@]}\n"

  for key in "${!subArr[@]}"
  do
    choices+=($(echo -e "$count $key")) &>/dev/null
    count=$(( count + 1 ))
  done
  echo "CHOICES: ${choices[2]}"
  sub_result=$(whiptail --title "ADMIN MENU" --menu "SUB:" 16 36 8 "${choices[@]}" 3>&1 1>&2 2>&3)
  rc=$?
  command=$(echo "${sub_arr[$sub_result]}" | cut -d';' -f2)
  echo "COMMAND: $command"

  #exit

#case $key in
#  'VIDEO_MODE')
#   ;;
# *)
#   ;;
#esac

}

runCommand() {
  args=(${@})
  nav_str="${nav[*]}"
  navstring=$(echo "${nav[*]}" | sed 's/ / > /g')
  parent=$(echo "$nav_str" | cut -d' ' -f2)
  key=$1
  #echo -e "\nnav: $navstring; parent: $parent; level: $level; key: $key"
  sleep 2
  #whiptail --title "$navstring" --msgbox "HERRO" 8 45
  #return

  case $parent in
     'SETUP')
        pre_str='stp'
        showSubMenu $pre_str $key
       ;;
     'TOOLS')
        pre_str='tls'
        showSubMenu $pre_str $key
       ;;
     'SYSTEM')
        pre_str='sys'
        showSubMenu $pre_str $key
        #rc=$(showSubMenu $pre_str $key);echo -e "\nRC: $rc"
       ;;
     'GAMES')
        pre_str='gam'
        showSubMenu $pre_str $key
       ;;
     *)
       echo -e "\nNot a valid option."
       ;;
  esac
}

##################################

[ -f $include_file ] \
&& source $include_file
include

#[ "$INCLUDED" ] \
#&& echo "succes!" \
#|| echo "failure" && exit 1

declare -a systemArr=('VIDEO_MODE' 'SHOW_LOGS' 'REBOOT')
declare -a setupArr=('CLEAN_INSTALL' 'CAFCA_SETUP' 'EMULATION')
declare -a toolsArr=('MC' 'EMULATIONSTATION' 'CONFIG_INFO')
declare -a gamesArr=($(cat /home/pi/CAFCA/GAMELIST))

declare -A mainArr=( \
  [SYSTEM]="${systemArr[@]}" \
  [SETUP]="${setupArr[@]}" \
  [GAMES]="${gamesArr[@]}" \
  [TOOLS]="${toolsArr[@]}" \
)

declare -A subArr=()

#declare -a sys_video=("0 SELECT_VIDEO_MODE; bash /home/pi/pat.sh")
#declare -a sys_video_mode=()

declare -a sys_video_mode+=( \
  "SELECT_VIDEO_MODE; bash /home/pi/pat.sh" \
  "SOMETHING_ELSE; run myprogram.exe" \
)


#declare -A arr_sys_video=( \
#  ['SETUP']='' \
#)

#declare -a pages
declare -a returnArr
declare -a prevArr


Main


##################################


#  result=$(
#     #whiptail --backtitle "$backtitle" \
#     whiptail --title "Select Game" \
#           --menu "$text"      \
#           0 0 0 "${mainArr[@]}"    \
#           3>&2 2>&1 1>&3
#  );
#}

