#!/bin/bash

teensy_kbd='usb-Teensyduino_Serial_Keyboard_Mouse_Joystick_1008140-if02-event-kbd'
count_file='/tmp/cafca_credits'

coin_key='KEY_ESC'
grep_str="EV_KEY $coin_key 1"

on_exit() {
  echo -e "\nSTOPPED"
  exit 1
}

read_input() {
  while read -r line; do
    pressed=$(echo "$line" | grep -c "$coin_key" | wc -w)
    if [[ $pressed ]]; then
      count=$(( $(cat $count_file) + 1 ))
      echo "$count" | sudo tee $count_file
    fi
  done< <(thd --dump "/dev/input/by-id/$teensy_kbd" 2>&1 |& grep --line-buffered "$coin_key" | awk -W interactive '{$1=$1;print}' | grep --line-buffered -w "$grep_str")
}

trap on_exit EXIT

touch $count_file
echo 0 | sudo tee $count_file &>/dev/null

read_input &

while true; do
  echo "COUNT: $(cat $count_file)"
  sleep 1
done

