#!/bin/bash
#printf "\n"

#shopt -s lastpipe

for src in arm core emmc uart v3d h264 isp pwm vec pixel dpi hdmi; do
   echo -e "$src: $(vcgencmd measure_clock $src)" | \
   awk -v OFS=\n -F':|=' '{
     name = $1;
     val = $3;
     val /= 1000;
     unit=" hz"

     if (val >= 10 * 1000) {
       val /= 1000;
       unit="Mhz"
     } else if (val >= 100) {
       unit="Khz"
     }

     cmd = "echo \"" val "\" | sed \x27s/./&./4\x27";
     cmd | getline val_form;
     close(cmd);

     printf "%s\t%8.2f %s\n", name, val_form, unit

   }'
done
