#!/bin/bash

#include_file='/home/pi/ADMIN/.sys/include.sh'
#[ -f $include_file ] && source $include_file
#include

admin_dir="/home/pi/ADMIN"
settings="$admin_dir/.sys/.settings"
states="$admin_dir/.sys/.states"
dump_file="/tmp/evdump"

timeout=300
count=0
asleep=0
last_len=0

proc_thd=
proc_dump=

#___________________________________________________

echo '' | sudo tee "$dump_file" &> /dev/null && sleep 0.5
sudo chmod 775 "$dump_file" && sleep 0.5

if [[ $(grep timeout_sys_default $settings | cut -d= -f2) -gt 0 ]]; then
  timeout=$(cat /boot/cmdline.txt | awk 'BEGIN{RS=" "}{$1=$1}1' | grep consoleblank | cut -d= -f2)
else
  timeout=$(grep -w timeout $settings | cut -d= -f2)
fi

echo -e "timeout: $timeout\n"

#----------------------------------------------------

function dump() {
  thd --dump /dev/input/event* | grep --line-buffered EV_KEY |& sudo tee "$dump_file" &> /dev/null &

  while true; do
    len=$(cat "$dump_file" | wc -l)

    [ "$len" -gt 100 ] && echo '' | sudo tee "$dump_file"

    if [[ $len == $last_len ]]; then
      (( ! $asleep )) && count=$(( count + 1 ))

      if (( "$count" > "$timeout" )); then
        echo "TIMEOUT!"
        asleep=1
        count=0
        printf "ASLEEP 1" > /tmp/pyserial.fifo
        sed -i '/ASLEEP/d' "$states" && sleep 0.5
        echo "BOOL ASLEEP 1" | sudo tee -a "$states" &> /dev/null &
      fi
    else
      if [[ $asleep > 0 ]]; then
        printf "ASLEEP 0" > /tmp/pyserial.fifo
        sed -i '/ASLEEP/d' "$states"
        echo "BOOL ASLEEP 0" | sudo tee -a "$states" &> /dev/null &
        asleep=0
      fi
      count=0
    fi

    last_len=$len
    sleep 1
  done
}

 dump

 #while true; do
 #  sleep 1
 #done
 exit


##############################################################################

function dump_old() {
  #thd --dump /dev/input/event* | sudo tee "$dump_file" &> /dev/null &
  thd --dump /dev/input/event* | grep --line-buffered EV_KEY |& sudo tee "$dump_file" &> /dev/null &

  while true; do
    len=$(cat "$dump_file" | wc -l)

    [ "$len" -gt 100 ] && echo '' | sudo tee "$dump_file"

    if (( ! $asleep )); then
      [[ $len == $last_len ]] && count=$(( count + 1 ))
      echo -e "count: $count"

      if (( "$count" > "$timeout" )); then
        echo "TIMEOUT!"
        asleep=1
        count=0
        printf "ASLEEP 1" > /tmp/pyserial.fifo
        sed -i '/ASLEEP/d' "$states" && sleep 0.5
        echo "BOOL ASLEEP 1" | sudo tee -a "$states" &> /dev/null &
      fi

    else
      if [[ $(grep ASLEEP "$states" | cut -d= -f2) == 0 ]]; then
        asleep=0
      elif [[ ! $len == $last_len ]]; then
        printf "ASLEEP 0" > /tmp/pyserial.fifo
        sed -i '/ASLEEP/d' "$states"
        echo "BOOL ASLEEP 0" | sudo tee -a "$states" &> /dev/null &
        asleep=0
      fi
      #(( ! $asleep )) && printf '\010' > /tmp/vkbdd.fifo
    fi

    last_len=$len
    sleep 1
  done
}
