#!/bin/bash

SCRIPT=$(readlink -f $0)
cafca_dir=$(dirname $SCRIPT)

log_dir="$cafca_dir/log"
log_file="$log_dir/CAFCA.log"
scan_log="$log_dir/scanlog.log"

ra_log="$log_dir/retroarch/retroarch.log"
crt_log='/dev/shm/CRT_Launcher.log'
rc_log='/dev/shm/runcommand.log'
rc_info='/dev/shm/runcommand.info'

retroarch="/opt/retropie/emulators/retroarch/bin/retroarch"
mame_core="/opt/retropie/libretrocores/lr-mame2003/mame2003_libretro.so"

system='mame-libretro'
game=''

game_dir="/home/pi/RetroPie/roms/$system"
config="$cafca_dir/cfg/$system.cfg"

data_dir="$cafca_dir/data/$system/offsets"
game_table=

matched=0

#________________________________________________________________________
#
# VARIABLES

args=("$@")

action='DUMP'
mode='RUNCMD'

debug=1
retro_running=0
game_listed=0

key_exit=0
key_coin=0
key_start=0

identified=0
matchlist=()


#virtual_kbd='usb-Teensyduino_Serial_Keyboard_Mouse_Joystick_1008140-if02-event-kbd'
teensy_kbd='usb-Teensyduino_Serial_Keyboard_Mouse_Joystick_1008140-if02-event-kbd'
coin_key="KEY_C"
start_key="KEY_S"
offsets=('0x1d4080a' '0x1dc180a')
regions=(12 13)
coin_addr=
credits=0

#_____________________________________________________
#
# SETUP


sudo touch $log_file && sleep 1

#exec > $log_file 2>&1
exec > >(sudo tee $log_file 2>&1)


echo -e "\nC A F C A\n"; echo -e `date "+%d/%m-%Y %T"` "\n\n"

if [ "${#args[@]}" -gt 0 ]; then
  echo -e "ARGS: \x27${args[@]}\x27 (n=${#args[@]})\n\n"
  action=$(echo "$1" | tr '[:lower:]' '[:upper:]')
  [ "${#args[@]}" -gt 1 ] && mode=$(echo "$2" | tr '[:lower:]' '[:upper:]')
else
  echo -e "NO ARGS\n\n" #args=("$@") #|| args=('none')
fi

[ ! -f "$ra_log" ] && sudo touch "$ra_log"
sleep 1

log_own=$(ls -l "$log_dir/retroarch" | grep "$ra_logname" | awk '{print $3" "$4}')

if [[ $log_own != "pi pi" ]]; then
  echo "setting log right to pi:pi"
  sudo chown pi:pi "$log_dir/retroarch/$ra_logname"
fi

#-----------------------------------------------------

Main() {
  echo -e "MODE:\t$mode\nACTION:\t$action\n\n"

if [[ "$action" == DUMP ]]; then
  if [[ "$mode" == RUNCMD ]]; then
    cafca_dump
  elif [[ "$mode" == LAUNCH ]]; then
    # launch retroarch
    pat='var'
  fi

elif [[ "$action" == SCAN ]]; then
  if [[ "$mode" == LAUNCH ]]; then
    if [ "${#args[@]}" -gt 2 ]; then
       system=$(echo "$3" | tr '[:upper:]' '[:lower:]')
    elif [ "${#args[@]}" -gt 3 ]; then
      system=$(echo "$3" | tr '[:upper:]' '[:lower:]')
      game=$(echo "$4" | tr '[:upper:]' '[:lower:]')
    fi
    cafca_scan
  fi
fi

#exit
}
#-----------------------------------------------------

cafca_dump() {
  serialSend "GAME_LOADED 1"
  retro_running=1

  if [[ "$mode" == RUNCMD ]]; then
    system=$(awk 'NR==1' $rc_info);echo -e "SYSTEM: $system\n"
    game=$(awk -F'/' 'NR==3 {print $NF}' $rc_info | cut -d. -f1);echo -e "GAME: $game\n"
  fi

  debug "GAME: $game"
  debug "SYSTEM: $system"
  serialSend "GAME_NAME $game"
  sleep 2
  serialSend "GAME_SYSTEM $system"

  #check_entry

  game_table="$cafca_dir/data/$system/offsets/$game"
  debug "GAME TABLE: $game_table"
  sed -i '/^$/d' "$game_table" # remove empty rows

  tail -f "$ra_log" | grep -c -m1 -q --line-buffered "hiscore memory file" &>/dev/null && debug "READY!\n"
  #serialSend "VFD 1 RA READY!"
  debug "CREDITS: $credits"

  [ ! -f "$game_table" ] && game_listed=1

  if [[ "$game_listed" ]]; then
    debug "GAME_LISTED: 1"
    serialSend "VFD 1 GAME LISTED"
    serialSend "GAME_ADDR 1"

    wait_coin
    debug "COIN INSERTED!"
    debug "CREDITS: $credits"

    #read_coin &
    get_regions
    serialSend "VFD 0 DONE!"
    sleep 5
  else
    debug "GAME_LISTED: 0"
    serialSend "VFD 1 GAME NOT LISTED"
    serialSend "GAME_ADDR 0"
  fi

  #printf 'c' > /tmp/vkbdd.fifo

  while (( $retro_running )); do
     retro_running=$(ps -ef | grep -v grep | grep -c -m1 retroarch)
     sleep 1
  done

  serialSend "GAME_STOPPED 1"

}

get_regions() {
  local region_list=$(sudo scanmem -p `pidof retroarch` -c"lregions;exit" 2>&1 |& awk -W interactive 'NR>14' | sed -e "s/\[//g" -e "s/\]//g")
  local misc_regs=()
  local data=$(cat "$game_table")
  local data_name='misc' # REM
  #local data_offset=$(echo "$data" | awk '{print $1}')
  #printf -v credit_string '%02d' "$credits" &>/dev/null

  debug "DATA: $data"

  # POPULATE MISC ARRAY
  while read -r line; do
    reg_name=$(echo "$line" | awk '{print substr($5, 0, length($5))}')
    reg_data=$(echo "$line" | awk '{print $1" 0x"substr($2,0,length($2))}')
    [[ "$reg_name" == "$data_name" ]] && misc_regs+=("$reg_data")
  done< <(echo "$region_list")

  entries=$(( $(cat "$game_table" | wc -l) ))

  # CHECK OFFSETS IN TABLE
  for (( r=0; r<$entries;r++ )); do
    OFFSET=$(echo "$data" | awk -v row="$(( r+1 ))" 'NR==row {print $1}')
    OFFS_NUM=$(echo "$data" | awk -v row="$(( r+1 ))" 'NR==row {print $2}')

    printf -v credit_string '%02d' "$credits" &>/dev/null

    debug "CREDIT STR: $credit_string"
    debug "REG $OFFS_NUM, OFFS: $OFFSET"

    # CHECK ALL MISC REGIONS
    for reg in "${misc_regs[@]}"; do
      REGNUM=$(echo "$reg" | awk '{print $1}')
      BASE=$(echo "$reg" | awk '{print $2}')

      if [[ "$REGNUM" == "$OFFS_NUM" ]]; then
        printf -v ADDR "0x%X\n" $(( BASE + OFFSET)); ADDR=$(echo "$ADDR" | tr '[A-Z]' '[a-z]')
        VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')

        #if [[ "$VAL" == "01" ]] || if [[ $VAL == 1 ]]; then
        #if [[ $VAL == $credits ]]; then
        if [[ $VAL == $credit_string ]]; then
          matched=1
          serialSend "CREDITS $credit_string"
          debug "M A T C H !"

          #coin_addr=$ADDR
          debug "REG: $REGNUM, COIN ADDR: $ADDR, VAL: $VAL"

          # CROSS CHECK
          printf 'c' > /tmp/vkbdd.fifo
          sleep 5
          VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')

          credits=$(( credits + 1 ))
          printf -v credit_string '%02d' "$credits" &>/dev/null
          debug "NEW VAL: $VAL"
          serialSend "VFD 1 VAL: $VAL"
          serialSend "CREDITS $credit_string"
          #break
        fi

        debug "  ENTRY: $REGNUM, ADDR: $ADDR, VAL: $VAL"
      fi
    done
  done

  debug "MATCHED: $matched"

  if [[ $matched -lt 1 ]]; then
    for (( r=0; r<$entries;r++ )); do
      OFFSET=$(echo "$data" | awk -v row="$(( r+1 ))" 'NR==row {print $1}')
      OFFS_NUM=$(echo "$data" | awk -v row="$(( r+1 ))" 'NR==row {print $2}')
      printf -v credit_string '%02d' "$credits" &>/dev/null

      for reg in "${misc_regs[@]}"; do
        REGNUM=$(echo "$reg" | awk '{print $1}')
        BASE=$(echo "$reg" | awk '{print $2}')
        printf -v ADDR "0x%X\n" $(( BASE + OFFSET)); ADDR=$(echo "$ADDR" | tr '[A-Z]' '[a-z]')
        VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')

        #if [[ $VAL == $credits ]]; then
        if [[ $VAL == $credit_string ]]; then
          matched=1
          #serialSend "VFD 6 MATCH!"
          serialSend "CREDITS $credit_string"
          debug "M A T C H !"

          #coin_addr=$ADDR
          debug "REG: $REGNUM, COIN ADDR: $ADDR, VAL: $VAL"

          # CROSS CHECK
          printf 'c' > /tmp/vkbdd.fifo
          sleep 5
          VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')

          credits=$(( credits + 1 ))
          printf -v credit_string '%02d' "$credits" &>/dev/null
          debug "NEW VAL: $VAL"
          serialSend "VFD 1 VAL: $VAL"
          serialSend "CREDITS $credit_string"
        fi
      done
    done
  fi
}


read_coin() {
  while (( $retro_running )); do
    thd --dump "/dev/input/by-id/$teensy_kbd" | grep -q "$coin_key" && credits=$(( credits + 1 )) #printf -v credits '%02d' 1 &>/dev/null
    serialSend "VFD 6 COIN INSERTED!"
  done
}

wait_coin() {
  thd --dump "/dev/input/by-id/$teensy_kbd" | grep -q "$coin_key" && credits=1 #printf -v credits '%02d' 1 &>/dev/null
  serialSend "VFD 6 COIN INSERTED!"
  #printf -v credits '%02d' 1 &>/dev/null
}

#________________________________________

check_regions() {
  for r in {0..1}; do
    reg="${regions[$r]}"
    reg_base=$(sudo scanmem -p `pidof retroarch` -c"option region_scan_level 3;reset;dregions !$reg;lregions;exit" 2>&1 | awk 'NR==20 {print "0x"substr($2, 0, length($2))}')
    echo -e "\nREGION $reg:\nBASE: $reg_base\n"
    for i in {0..1};do
      reg_offset="${offsets[$i]}"
      printf -v ADDR "0x%X\n" $(( reg_base + reg_offset)) &>/dev/null;ADDR=$(echo "$ADDR" | tr '[:upper:]' '[:lower:]')
      val=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')
      echo -e "\nOFFS: $reg_offset\n$ADDR: $val"
      if [[ $val == $credits ]]; then
      #if [[ $val == 1 ]]; then
         coin_addr=$ADDR
         echo -e "COIN ADDR: $coin_addr"
         break
      fi
    done
    echo -e "________________________________________________"
  done
}

get_region_data() {

  local region_list=$(sudo scanmem -p `pidof retroarch` -c"lregions;exit" 2>&1 |& awk -W interactive 'NR>18' | sed -e "s/\[//g" -e "s/\]//g")
  local misc_regs=()
#  local data=

#  [ -f $data_table ] && \
#    data=$(cat $data_table | awk 'NR==2');
    data_offset=$(echo "$data" | awk '{print $1}') #;
    data_reg=$(echo "$data" | awk '{print $2}') #;
    data_name=$(echo "$data" | awk '{print $3}') #;
    data_pos=$(echo "$data" | awk '{print $4}') #;

  echo -e "data: $data\noffset: $data_offset\nregion: $data_reg\npos: $data_pos\nname: $data_name\n"

  REG_RANGE_LO=$(( $data_reg - 5 ))
  REG_RANGE_HI=$(( $data_reg + 5 ))

  while read -r line; do
   reg_name=$(echo "$line" | awk '{print substr($5, 0, length($5))}')
   if [[ "$reg_name" == "$data_name" ]]; then
     reg_data=$(echo "$line" | awk '{print $1" 0x"substr($2,0,length($2))}')
     misc_regs+=("$reg_data")
   fi
  done< <(echo "$region_list")

  for reg in "${misc_regs[@]}"; do
    REGNUM=$(echo "$reg" | awk '{print $1}')
    BASE=$(echo "$reg" | awk '{print $2}'); OFFSET="$data_offset"

    #if [[ "$REGNUM" == "$data_reg" ]]; then
    #if [ "$REGNUM" -gt "$REG_RANGE_LO" ] && [ "$REGNUM" -le "$REG_RANGE_HI" ]; then
      printf -v ADDR "0x%X\n" $(( BASE + OFFSET)); ADDR=$(echo "$ADDR" | tr '[A-Z]' '[a-z]')
      dump_line=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 |& awk -W interactive 'NR==15') #| sed -e "s/\[//g" -e "s/\]//g")
      credit_var=$(echo "$dump_line" | awk -F' ' '{print $2}')
      credit_dec=$( printf "%d" "0x$credit_var")
      #echo "$credit_var"
      #case $credit_var in
      #  ''|*[!0-9]*) ;;
      #  *) echo "$credits_var" ;;
      #esac
      echo -e "REG $REGNUM:\nBASE: $BASE;\nADDR: $ADDR\nVALUE: $credit_var\n"
      if (( $credit_dec == $credits)); then
         echo -e "\nMATCH!"
         sleep 2
      fi
      sleep 0.5
    #fi
  done

#exit
}

check_entry() {
  game_table="$cafca_dir/data/$system/offsets/$game"
  debug "TABLE: $game_table"
  [ ! -f "$game_table" ] && serialSend "VFD 0 NO ADDR" \
  || serialSend "VFD 0 ADDR!"
  #exit 1
  #|| (while :; do sleep 1; done)
}

press_key() {
  key="$@"
  printf "$key" > /tmp/vkbdd.fifo
}

debug() {
   if (( "$debug"  )); then
      msg="$@"
      #msg=$1
      echo -e "[DEBUG] $msg"
   fi
}

serialSend() {
 [ -c /dev/ttyACM0 ] &&  printf "${@}" > /tmp/pyserial.fifo #&>/dev/null
  sleep 3
}

#-----------------------------------------------------
# OLD:

wait_for_coin() {
  while read -r line; do
    echo $line | grep "EV_KEY" | grep -q "$coin_key" && break
  done< <(evtest "/dev/input/by-id/$virtual_kbd")
}

wait_for_keys() {
  while read -r line; do
    echo $line | grep "EV_KEY" | grep -Eq "*$coin_key*|*$start_key*" && break
  done< <(evtest "/dev/input/by-id/$virtual_kbd")
}


check_regions() {
  for r in {0..1}; do
    reg="${regions[$r]}"
    reg_base=$(sudo scanmem -p `pidof retroarch` -c"option region_scan_level 3;reset;dregions !$reg;lregions;exit" 2>&1 | awk 'NR==20 {print "0x"substr($2, 0, length($2))}')
    echo -e "\nREGION $reg:\nBASE: $reg_base\n"
    for i in {0..1};do
      reg_offset="${offsets[$i]}"
      printf -v ADDR "0x%X\n" $(( reg_base + reg_offset)) &>/dev/null;ADDR=$(echo "$ADDR" | tr '[:upper:]' '[:lower:]')
      val=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')
      echo -e "\nOFFS: $reg_offset\n$ADDR: $val"
      if [[ $val == $credits ]]; then
      #if [[ $val == 1 ]]; then
         coin_addr=$ADDR
         echo -e "COIN ADDR: $coin_addr"
         break
      fi
    done
    echo -e "________________________________________________"
  done
}

cafca_scan() {
  debug "CAFCA SCAN"
  [[ -n "${game}" ]] && debug "GAME: $game" || debug "\x27\$game\x27 not defined!"
  [[ -n "${system}" ]] && debug "SYSTEM: $system\n" || debug "\x27\$system\x27 not defined!"
  [[ -n "${game_dir}" ]] && debug "GAME PATH: $game_dir/$game.zip" || debug "\x27\$game_dir\x27 not defined!"

  "$retroarch" -L "$mame_core" --config "/opt/retropie/configs/$system/retroarch.cfg" "$game_dir/$game.zip" --verbose --log-file "$log_file" 2>&1 &>/dev/null &
  #/opt/retropie/emulators/retroarch/bin/retroarch -L /opt/retropie/libretrocores/lr-mame2003/mame2003_libretro.so --config /opt/retropie/configs/mame-libretro/retroarch.cfg --appendconfig /home/pi/CAFCA/cfg/arcade.cfg /home/pi/RetroPie/roms/mame-libretro/aliens.zip --verbose --log-file /home/pi/CAFCA/log/retroarch/retroarch.log 2>&1 &>/dev/null &

  serialSend "GAME_LOADED 1"
  retro_running=1

  tail -f "$log_file" 2>/dev/null | grep -c -m1 -q --line-buffered "hiscore memory file" && echo -e "\n" &>/dev/null
  debug "READY!\n"
  sleep 2
  game_name=$(grep -m1 "lookup name:" "$log_file" | awk -F' ' '{print $8}')

  [[ -n "${game_name}" ]] && debug "GAME NAME: $game_name" || debug "\x27\$game_name\x27 not defined!"
  sleep 1

  scanCoin
  echo -e "\nMATCHLIST LEN: ${#matchlist}\n"
  [[ "${#matchlist}" -gt 0 ]] && set_default_match
  sleep 1
  #exit
}

scanCoin() {
   address=0
   line_num=0

   debug "RUNNING SCANMEM"
   echo -e "`date`\n" | sudo tee "$scan_log" &>/dev/null
   sleep 1

   region_count=$(sudo scanmem -p `pidof retroarch` -c"lregions;exit" 2>&1 |& awk -W interactive 'NR>15' | grep "regions found." | awk '{print $2}')

   #echo "REGION LIST: $region_list" | sudo tee REGION_LIST
   # REM Test

   while read -r line; do
      echo "$line" | grep -q "> list" && getData
      #echo "$line" | grep -q "> list" && debug "\nLISTING..\n"
      #echo "$line" | grep -q "> exit" && getData
      [ "$identified" -gt 0 ] && break
   done< <(tail -f "$scan_log" 2>&1) &

   sleep 1

   sudo scanmem -p `pidof retroarch` -c'lregions' 2>&1 |& sudo tee -a "$scan_log"
   #[ "$identified" -gt 0 ] && set_default_match
}


getData() {
  row_num=$(( $(cat "$scan_log" | grep -n "> list" | awk -F':' '{print $1}') +1 ))
  matchlist=$(cat "$scan_log" | awk -v row="$row_num" 'NR >= row' | grep -E '\[\s')
  matches=$(echo "$matchlist" | wc -l)

  #debug "ROW NUM: $row_num\n"
  debug "MATCHLIST: \n$matchlist\n"

  appendData "MATCHES $matches\n"
  appendData "\n_.,;^ MATCHES ^;,._"
  appendData "___________________\n"

  for (( i=1;i<="$matches";++i ));do
     match_row=$(echo "$matchlist" | awk -v L="$i" 'NR==L' | tr -d '[|]|,|+')
     addr=$(echo "$match_row" | awk -F' ' '{print $2}')
     offset=$(echo "$match_row" | awk -F' ' '{print $4}')
     region=$(echo "$match_row" | awk -F' ' '{print $3}')
     reg_name=$(echo "$match_row" | awk -F' ' '{print $5}')
     region_adj=$(( region + 1  ))

     region_list=$(sudo scanmem -p `pidof retroarch` -c"option region_scan_level $scan_level;reset;lregions;exit" 2>&1 |& awk -W interactive 'NR>18' | sed -e "s/\[//g" -e "s/\]//g")
     reg_start=$(echo "$region_list" | awk -v R="$region_adj" 'NR==R' | sed -e "s/  \+/ /g" | awk -F' ' '{print $2}' | sed -e "s/,//g")

     var_length=$(echo "$match_row" | awk -F' ' '{print $6}')
     data_type=$(echo "$match_row" | awk -F' ' '{print $7}')

     appendData "MATCH $i:\n"
     appendData "ADDR      $addr"
     appendData "OFFSET    $offset"
     appendData "REGION    $region"
     appendData "REG_NAME  $reg_name"
     appendData "REG_START $reg_start"
     appendData "DATA_TYPE $data_type"
     appendData "VAR_LEN   $var_length\n"
     appendData "-------------------\n"

     calculateOffset "0x$reg_start" "0x$addr"
  done

  appendData "___________________\n"

  identified=1
  sleep 1
  echo -e "\nTYPE \x22EXIT\x22 to continue.\n"
  return
}

appendData() {
  [ "${#@}" -gt 0 ] && echo -e "$@" | sudo tee -a "$data_table" &>/dev/null || return 1
  [ "$debug" -gt 0 ] && echo -e "DATA: ${@}"
}




calculateOffset() {
   args=("$@")
   [[ "${#args[*]}" -ne 2 ]] && return || BASE="$1"; ADDR="$2"
   #printf -v OFFSET "0x%X\n" $(( ADDR - BASE ));echo "OFFSET: $OFFSET"
   printf -v OFFSET "0x%X\n" $(( ADDR - BASE )); OFFSET=$(echo "$OFFSET" | tr '[A-Z]' '[a-z]')
   printf -v NEW_ADDR "0x%X\n" $(( BASE + OFFSET)); NEW_ADDR=$(echo "$NEW_ADDR" | tr '[A-Z]' '[a-z]')

   echo -e "\nOFFSET: $OFFSET"
   echo -e "VERIFYING ADDR: $NEW_ADDR\n\n"
}


#press_key() {
#  key="$@"
#  printf "$key" > /tmp/vkbdd.fifo
#}


cleanup() {
  debug "Cleaning up..."
  [ "$retroarch_running" ] && printf '\033' >/tmp/vkbdd.fifo #sudo pkill retroarch
  #sleep 2
  #[ "$retroarch_running" ] && sudo pkill retroarch
  sudo pkill tail

  #sudo cp "$log_file" "$cafca_dir/.BAK/retroarch.log.bak"
  #echo -e "\n" | sudo tee "$log_file" &>/dev/null
  #sudo rm "$cafca_dir"/*.lpl &>/dev/null

}

trap cleanup EXIT

Main

exit

#________________________________________________________________________


#Main() {
  #wait_for_coin
  #sleep 1

  #echo "credits: $credits"
  #check_regions

  #[ "${#coin_addr}" -lt 1 ] && return

  #val=$(sudo scanmem -p `pidof retroarch` -c"dump $coin_addr 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')
  #echo -e "Credits: $val"
  #printf "CREDITS $val" > /tmp/pyserial.fifo


  #while (( $retro_running )); do
  #  retro_running=$(ps -ef | grep -v grep | grep -c -m1 retroarch)
  #  wait_for_keys
  #  #wait_for_coin
  #  sleep 1
  #  val=$(sudo scanmem -p `pidof retroarch` -c"dump $coin_addr 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')
  #  echo -e "Credits: $val"
  #  printf "CREDITS $val" > /tmp/pyserial.fifo
  #done

  #serialSend "GAME_STOPPED 1"

#}
