#!/bin/bash

script_dir=$( dirname -- "$( readlink -f -- "$0"; )"; )
cafca_dir='/home/pi/CAFCA'
log_file="$cafca_dir/log/CAFCA.log"
gun_serial_port='/dev/ttyACM1'
serial_script="$cafca_dir/cmd/serial_gun.py"
game_table="$script_dir/addr/gun"
entries=$(cat "$game_table" | wc -l)

declare -A data
declare -a adds
declare -a noms
declare -a vals=(0 0)

reg_offs=
ADDR=
VAL=

exec > >(sudo tee -a "$log_file" 2>&1)

main() {

  for (( i=0; i<$entries; i++ )); do
    entry=$(cat "$game_table" | awk -v l="$(( i + 1 ))" 'NR==l')
    get_gamedata "$entry"

    scan_args="option region_scan_level 3;reset;dregions !${data['NUM']};lregions;exit"
    region=$(sudo scanmem -p `pidof retroarch` -c"$scan_args" 2>&1 |& grep --line-buffered -i "^[\[]")	#grep --line-buffered -P -A1000 '\[ 0\]' |& sed s'/[][,]//g' #| sudo tee "$file_regionlist" &>/dev/null && sudo sed -i '/> exit/d' "$file_regionlist"
    reg_offs=$( echo "0x$(echo $region | cut -d' ' -f3 | sed 's/,//')")  #$(echo "0x$reg_start")

    get_addr "$reg_offs"

    noms+=("${data['PARAM']} ")
    adds+=($ADDR)

    printf "\n"
    sleep 1
  done


  while true; do
    for (( n=0; n<$entries; n++ )); do

      dump_addr "${adds[$n]}"
      #if [[ $VAL != $LASTVAL ]]; then
      if [[ $VAL != ${vals[$n]} ]]; then
        echo  "${noms[$n]} ${adds[$n]} - val: $VAL"
        [ -c "$gun_serial_port" ] && sudo python3 "$serial_script" "${noms[$n]} $VAL"
        sleep 0.1
        vals[$n]=$VAL
      fi
    done
  done

}

dump_addr() {
  pos="$1"
  VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $pos 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')
}

get_addr() {
  BASE="$1"
  OFFS="${data[OFFS]}"
  ADDR="";printf -v ADDR "0x%X\n" $(( BASE + OFFS)) &>/dev/null; ADDR=$(echo "$ADDR" | tr '[A-Z]' '[a-z]')
}

get_gamedata() {
  local table_data="$1"
  data[PARAM]=$(echo "$table_data" | awk '{print $1}')
  data[OFFS]=$(echo "$table_data" | awk '{print $2}')
  data[NUM]=$(echo "$table_data" | awk '{print $3}')
  data[NAME]=$(echo "$table_data" | awk '{print $4}')
  data[TYPE]=$(echo "$table_data" | awk -F'\[' '{print substr($2,0,length($2))}')

  printf "\n\nget_gamedata():\n"
  for d in "${!data[@]}"; do
    printf "$d:\t\t${data[$d]}\n"
  done
}

main
