#!/bin/bash


NEWT_COLORS_1='
    root=green,black
    border=green,black
    window=black,black
    shadow=black,grey
    title=green,black
    button=black,green
    actbutton=green,black
    compactbutton=green,black
    checkbox=green,black
    actcheckbox=black,green
    entry=black,green # textfelt?
    disentry=green,black
    label=green,black
    listbox=green,black
    actlistbox=brightgreen,black
    sellistbox=black,green
    actsellistbox=black,green
    textbox=green,black
    acttextbox=green,black
    emptyscale,green
    fullscale=,green
    helpline=green,black
    roottext=black,green
'
export NEWT_COLORS=$NEWT_COLORS_1

  #cafca_path=$(grep "PATH_CAFCA" SETTINGS | awk '{print $2}')
  cafca_path=/home/pi/CAFCA
  gamelist=$cafca_path/data/.gamelist
  #joy2key='/home/pi/ADMIN/CMD/joy2key/joy2key.sh'
  #romspathstored=$(grep "ROMS" $cafca_path/SETTINGS | awk '{print $2}')

  cmd=('setMode' 'showLogs' 'cfgEdit')

  Main() {

    choice=$(
      whiptail --title "  CAFCA MENU:  " --menu "Select entry: " 16 32 9 \
  	  "0" "CHANGE MODE" \
	  "1" "SHOW LOGS" \
	  "2" "EDIT CFGS" 3>&2 2>&1 1>&3
    )

    rc=$?

    [ $rc -gt 0 ] && exit

    "${cmd[$choice]}"

  }

  setMode() {
    mode=$(
      whiptail --title "  CAFCA MENU:  " --menu "Select entry: " 16 32 9 \
	  "0" "DUMP" \
	  "1" "SCAN" 3>&2 2>&1 1>&3
    )
    rc=$?

    [ $rc -gt 0 ] && Main

    action=$(grep "action" "$cafca_path/data/.settings" | cut -d= -f2)
    setting=$(grep "action" "$cafca_path/data/.settings" | cut -d= -f1)

    [[ $mode == 0 ]] && newmode="DUMP" || newmode="SCAN"

    if whiptail --yesno "SET MODE TO $newmode?\n\n(CURRENT:   $action)" 10 24; then
      sudo cp -f "$cafca_path/data/.settings" "$cafca_path/data/.settings.bak"
      sudo sed -i '/action/d' "$cafca_path/data/.settings"
      echo "$setting=$newmode" | sudo tee -a "$cafca_path/data/.settings" &>/dev/null
      sleep 1
      whiptail --msgbox "ACTION SUCCESFULLY SET TO $newmode" --title "SUCCESS" 10 32

    else
      setMode
    fi
  }

  showLogs() {
    clear
    cat "$cafca_path/log/CAFCA.log" | less
  }

  cfgEdit() {
    sudo bash "$cafca_path/setup/cfg_editor.sh" #&& exit
  }

  startJoy() {
    JOY_NAME='SHANWAN'
    DEV=$(ls -l /dev/input/by-id | grep "$JOY_NAME" | grep js | awk -F'../' '{print "/dev/input/"$2}')
    PROCS=$(ps -ef | grep -v grep | grep -wc joy2key.py)

    if [[ $PROCS -lt 1 ]]; then
      python3 "/home/pi/ADMIN/CMD/joy2key/joy2key.py" "$DEV" kcuf1 kcub1 kcud1 kcuu1 0x0a 0x20 &
    fi
  }

  exitFunc() {
    [[ $referer == ES ]] && kill -9 $(ps -ef | grep -v grep | grep -i joy2key.py | awk '{print $2}') &>/dev/null
    clear
  }

  referer="$1"

  [[ $referer == ES ]] && startJoy

  trap 'exitFunc' EXIT SIGINT INT

  Main
