#!/bin/bash


log_path='/boot/boot.log'
[ ! -f "$log_path" ] && touch "$log_path"
sudo chmod 775 "$log_path"
sleep 1

#exec > >(sudo tee "$log_path" 2>&1)
exec > $log_path 2>&1

include_file='/home/pi/ADMIN/.sys/include.sh'
[ -f $include_file ] && source $include_file
include

#____________________________________________________


Main() {
   datestring=$(date | cut -c -20)
   echo -e "\nA U T O S T A R T   L O G:"
   echo -e "( $datestring )\n\nlogfile: $log_path"

   # FILE OPERATIONS
     #sudo cp -f "$HOMEDIR/ADMIN/.sys/.states.default" "$HOMEDIR/ADMIN/.sys/.states"
     sudo cp -f "$HOMEDIR/ADMIN/.sys/.states.default" "$HOMEDIR/ADMIN/.sys/.states"
     sudo chmod 777 "$HOMEDIR/ADMIN/.sys/.states"

     sudo cp -f "$HOMEDIR/CAFCA/data/.states.default" "$HOMEDIR/CAFCA/data/.states"

     #ls -la /dev/serial/by-id | grep GUN4ALL | awk -F'/' '{print $NF}' | sudo tee -a "$HOMEDIR/ADMIN/.sys/.settings"

     fifo_path='/tmp/serial.fifo'

     sudo mkfifo "$fifo_path" && sleep 1 && \
     sudo chown pi:root "$fifo_path" && \
     sudo chmod 775 "$fifo_path"

     #sudo mkfifo /tmp/pyserial.fifo && sleep 1 && sudo chmod 777 /tmp/pyserial.fifo

   # DRIVER INITS
   #-------------------------------------------------

     #echo -e "`date +%F`\n" > "$HOMEDIR/ADMIN/.log/es.log" #&> /dev/null
     echo -e "E M U L A T I O N S T A T I O N   L O G\n" > "$HOMEDIR/ADMIN/.log/es.log" #&> /dev/null

     sudo chown pi:pi "$HOMEDIR/ADMIN/.log/joy2key.log"
     sudo thd --triggers /etc/triggerhappy/triggers.d/teensy.conf --socket /var/run/thd.socket --user root --daemon --deviceglob /dev/input/by-id/usb-Teensyduino_Serial_Keyboard_Mouse_Joystick_1008140-if02-event-kbd
     sudo -u pi bash -c "bash $HOMEDIR/ADMIN/CMD/joy2key/joy2key.sh START"
     #sh /home/pi/wiimote.sh &
     #tvservice -c "NTSC 4:3 P"; sudo python3 /home/pi/tweakvec/tweakvec.py --preset PAL60; fbset -depth 8; fbset -depth 32; tvservice -s
     #fbset -xres 512 -yres 288
     #amixer -c 1 set "Headphone" 100
     #amixer -c 1 set "Master" 90%


   # SCRIPTS
   #--------------------------------------------------
     #printf '' | sudo tee "$HOMEDIR/ADMIN/.log/serial.log" &> /dev/null
     #tail -F /tmp/pyserial.fifo | sudo tee "$HOMEDIR/ADMIN/.log/serial.log" &> /dev/null
     #sudo python3 "$HOMEDIR/ADMIN/CMD/PYTHON/SERIAL/serial_daemon.py" &

     #sudo bash "$HOMEDIR/ADMIN/CMD/SERIAL/SERIAL.sh" &
     sudo bash "$HOMEDIR/ADMIN/CMD/SERIAL/SERIAL_.sh" &
     sleep 1


     #printf "BOOTED 1" > "$fifo_path" #/tmp/pyserial.fifo #printf "BOOTED 1;" > /dev/ttyACM0 #serialSend "BOOTED 1"
     echo -e "0:BOOTED 1" > "$fifo_path" #/tmp/pyserial.fifo #printf "BOOTED 1;" > /dev/ttyACM0 #serialSend "BOOTED 1"

     sudo sed -i '/BOOTED/ s/BOOTED=0/BOOTED=1/' "$HOMEDIR/ADMIN/.sys/.states"
     sudo sed -i '/UI/ s/UI[=].*$/UI=TERM/' "$HOMEDIR/ADMIN/.sys/.states"

     #sudo sed -i '/UI/ s/UI=TERM/BOOTED=1/' "$HOMEDIR/ADMIN/.sys/.states"
     #sudo sed -i '/UI/d' "$HOMEDIR/ADMIN/.sys/.states" && sleep 1 && echo 'VAR UI=TERM' | sudo tee -a "$HOMEDIR/ADMIN/.sys/.states" &>/dev/null

     #sudo bash "$HOMEDIR/ADMIN/CMD/SLEEP/SLEEP.sh" &

     #t=$(( $(date +%s%N) / 1000 )); t=${t:6}
     #export ns=$t
     #env | grep ns | grep -oe '[^=]*$'

   #--------------------------------------------------
     snd_dir="$HOMEDIR/ADMIN/FILES/SAMPLES"
     samples=($(ls -l $snd_dir | awk '{print $9}'))
     rand=$[$RANDOM % ${#samples[@]}]
     sample="$snd_dir/${samples[$rand]}"
     #aplay -D default "$snd_dir/${samples[$rand]}" &
     #aplay -c 2 -D hw:1,0 "$snd_dir/${samples[$rand]}" &
     sudo bash "$HOMEDIR/ADMIN/CMD/PLAY/play.sh" "$sample" 3 &

   #--------------------------------------------------

     #sleep 2
     #emulationstation #auto
     #sleep 5
     #get_sysinfo
     #compile_logs

   #--------------------------------------------------

     #sudo bash /home/pi/ADMIN/BOOT.sh &
     #python3 /home/pi/menu/admin/bootSerial.py &
     #bash /home/pi/menu/admin/startup-sound/randSound.sh &

     #asciiview /home/pi/_files/img/arcade-poster-invert.png &
     #ascii_pid=$!
     #sleep 2
     #sudo kill -9 "$ascii_pid"

   # BOOT MENUS
     #bash /home/pi/menu/_boot.sh
     #bash /home/pi/menu/dialog_mnu.sh
     #bash /home/pi/menu/list-menu.sh

     #emulationstation #auto
     #emulationstation --screenoffset 32 0 #auto

}

get_sysinfo() {

 # HARDWARE:
   # Model:
   data_model=$(cat /proc/cpuinfo | grep Model | cut -d':' -f2 | sed 's/ //')
   data_serno=$(cat /proc/cpuinfo | grep Serial | cut -d ' ' -f 2 | cut -c 9- | awk '{print "0x" $0}')
   data_ip=$(hostname -I | cut -d' ' -f1)
   echo -e "\n"
   echo -e "MODEL: $data_model"
   echo -e "SERIAL: $data_serno\n"
   echo -e "IP ADDR: $data_ip\n"


 # BOOT-INFO:
   # boot times:
   sudo systemd-analyze | xargs | sed 's/(//g; s/)//g' | awk -F' ' '{print "BOOT TIMES:\n" $5 "\t\t" $4 "\n" $8 "\t" $7 "\n" $1 "\t\t" $10}'

 # SYSTEM:
   # free disk space:
   echo -e "\nDISK USAGE:"

   freekeys=($(free --total | awk 'NR==1' | sed -e "s/ \+/\n/g" | tail -n6))
   freevals=($(free --total | awk 'NR==2' | sed -e "s/ \+/\n/g" | tail -n6))

   for i in "${!freekeys[@]}"; do
      [ "$i" -lt 4 ] && tabstr="\t\t" || tabstr="\t"
      echo -e "${freekeys[i]}$tabstr${freevals[i]}"
      #printf "%s %s\n" "${freekeys[i]}" "${freevals[i]}"
   done

  sleep 2

 # NETWORK:

  # WLAN
  echo -e "\nWLAN (IWConfig):\n"
  iwconf=$(sudo iwconfig wlan0 | sed -e "s/ \+/ /g")

  echo "$iwconf" | cut -d' ' -f 2- | awk -F' ' 'NR==1' | cut -d' ' -f -2
  echo "$iwconf" | cut -d' ' -f 2- | awk -F' ' 'NR==1' | cut -d' ' -f 3- | sed -e "s/:/ /g; s/\"/'/g" | cut -c 2-
  echo "$iwconf" | cut -d' ' -f 5- | awk -F' ' 'NR==2 {print $1 "_" substr($2,0,length($2)) " " $3}'
  echo "$iwconf" | awk -F' ' 'NR==3 {print $1"_"$2$3}' | sed 's/=/ /g'
  echo "$iwconf" | cut -d' ' -f 3- | awk -F' ' 'NR==2 {print $1 " " $2}' | sed -e "s/:/ /g"
  echo "$iwconf" | awk -F' ' 'NR==7' | cut -d' ' -f 2,3 | sed 's/ /_/g; s/=/ /g'
  echo "$iwconf" | awk -F' ' 'NR==7' | cut -d' ' -f 4,5,6 | sed 's/ /_/; s/=/ /'


  #serial_num=$(cat /proc/cpuinfo | grep Serial | cut -d ' ' -f 2 | cut -c 9- );echo "$serial_num"
  #throttled=$(vcgencmd get_throttled)
  #echo -e "serial: $serial_num"
  #echo -e "throttled: $throttled"
}


serialSend() {
  serial_script='/home/pi/ADMIN/CMD/PYTHON/SERIAL/serial_send.py'
  [ -c /dev/ttyACM0 ] && sudo python3 "$serial_script" "$@" 1
}

compile_logs() {
  echo -e "\n____________________________\n"

  echo -e "LOG DUMP:\n"
  echo -e "\n----------------------------\n"

  echo -e "  -DMESG:\n"
  while read -r line; do
    [ $(echo $line | grep -c '^$') -lt 1 ] && echo $line | sed 's/:/:\t/'
  done< <(dmesg | awk -F']' '{print $2}' | awk '{$1=$1;print}')
  echo -e "\n----------------------------\n"

  #echo -e "  -LOG-MESSAGES:\n"
  #cat /var/log/messages | cut -d']' -f 2-

}

Main

#if [[ $(ps -ef | grep -c emulationstation) -gt 0 ]];
#then
#  sudo sed -i '/EMUST_RUNNING/d' "$HOMEDIR/ADMIN/.sys/.states"
#  sleep 0.5
#  echo "BOOL EMUST_RUNNING=1" | sudo tee -a "$HOMEDIR/ADMIN/.sys/.states"
#fi

while :;do
  sleep 1
done
#_____________________________________


