#!/bin/bash

IFS=$' \t\n'

#--- setup
FIFO="/tmp/myfifo.fifo"
rm -f "$FIFO"
mkfifo "$FIFO"

#--- sending data in background
for (( i = 0; i < 10; i++ )); do echo $i; sleep 1; done >"$FIFO" &

#--- receiving data
echo "start" && while read line; do echo "> $line"; done < "$FIFO" && echo "stop"

#--- clean
IFS=$' \t\n'
rm -f "$FIFO"
exit
