#!/usr/bin/env python3 -*- coding: utf-8

import serial
import os
import sys
from time import sleep
from datetime import datetime
from subprocess import PIPE, run
from threading import Event, Thread

#__________________________________________________
#
# SETUP:


serial_port = "/dev/ttyACM0"
#fifo_path = "/tmp/pyserial.fifo"
fifo_path = "/tmp/test.fifo"
fifo = ''
inbox = ['HELLO']

admin_dir = os.path.splitext('/home/pi/ADMIN')[0]
admin_states = os.path.splitext(admin_dir + '/.sys/.states')[0]

cafca_dir = os.path.splitext('/home/pi/CAFCA')[0]
cafca_states = os.path.splitext(cafca_dir + '/data/.states')[0]

log_dir = os.path.splitext('/home/pi/ADMIN/.log')[0]
log_file = (str(os.path.splitext(log_dir + '/serial_test')[0])+'.log')
#log_file = (str(os.path.splitext(log_dir + '/serialpy')[0])+'.log')
writeable = True
hide = " >/dev/null 2>&1"

#--------------------------------------------------

try:
    print("opening fifo")
    fifo = open(fifo_path, "r")
    pass

except Exception as e:
    print("error opening fifo:",e)
    pass


def checkFifo():
    if len(inbox) > 0:
        print("inbox:",inbox)
        inbox = []


def setup():
    try:
        if not os.path.exists(log_file):
            os.system('sudo touch ' + log_file)
            sleep(1)

        os.system('sudo chmod 775 ' + log_file)
        sleep(1)

        thread_fifo = Thread(target=checkFifo)
        thread_fifo.start()

    except Exception as e:
        print("error writing logfile:",e)
        writeable = False

    os.system('echo \x22\x23 SERIAL LOG\n\x23 ' + str(f'{datetime.today():%h %e %Y}') + '\n\x22 | sudo tee ' + log_file + hide)

    write_log("_SETUP","DONE")
#__________________________________________________
#
# FUNCTIONS:

def daemon():
    inbox.append('Science')
    print(f"DAEMON")
    sleep(10)
    fifo.close()
    os._exit(1)

def loop():

    if os.path.exists(serial_port):
        print("Found serial port",serial_port,"!")
        sleep(1)

        with serial.Serial('/dev/ttyACM0', 9600, timeout=1) as arduino:
            try:
                sleep(0.1)

                if arduino.isOpen():
                    arduino.reset_input_buffer()

                    while True:
                        try:
                            if arduino.inWaiting()==0:
                                checkFifo()
                                msg = read_fifo()

                                if len(msg)>0:
                                    arduino.write(msg.encode())

                            elif arduino.inWaiting()>0:
                                line = arduino.readline().decode('utf-8').strip()

                                write_log("TEENSY",line)
                                nom = line.split()[0]

                                arduino.flushInput()
                                checkInbox(line)

                        except serial.SerialException as se:
                            print("Serial port error:",se)
                            break

            except Exception as e:
                print(f"Error opening Arduino:",e)

            except KeyboardInterrupt:
                print("KeyboardInterrupt has been caught.")
                arduino.close()
                fifo.close()
                os._exit(1)
    else:
        print(f"Waiting for {serial_port}...")
        sleep(5)


#--------------------------------------------------

def send_fifo(msg):
    os.system('printf \x22' + msg + '\n\x22 > /tmp/pyserial.fifo')

def checkInbox(input):
    caller = input.split()[0]

    if caller == 'RPI':
        pos = input.find('RPI') + 4
        msg = input[pos:]

        if msg == "WAKEUP":
            os.system("sed -i '/ASLEEP/d' " + admin_states)
            sleep(0.5)
            os.system("echo 'BOOL ASLEEP=0' | sudo tee -a " + admin_states + hide)

        if msg == "GAME_LOADED 1":
            os.system("sed -i '/GAME_LOADED/d' " + cafca_states)
            sleep(0.5)
            os.system("echo 'BOOL GAME_LOADED=1' | sudo tee -a " + cafca_states + hide)

        if msg == "GAME_STOPPED 1":
            os.system("sed -i '/GAME_LOADED/d' " + cafca_states)
            sleep(0.5)
            os.system("echo 'BOOL GAME_LOADED=0' | sudo tee -a " + cafca_states + hide)
    #else:
    #    line = input;
    #    if line == "RESET":
    #        send_fifo('VFD 1 RPI SAYS HELLO')

    #if caller == 'AVR':
    #    pos = input.find('AVR') + 4
    #    line = input[pos:]


def read_fifo():
    output = ''
    line = fifo.readline()

    if line:
        output = line.replace('\n', '')
        output = output + ";"
        write_log('_FIFO>',line)
    return str(output)

#--------------------------------------------------

def write_log(src = ' ', msg = ' '):
    timestr = f'{datetime.today():%T}'

    if writeable:
        os.system("echo \x22[" + timestr + "] " + src + ": \x27" + msg + "\x27\x22 | sudo tee -a " + log_file) #+ hide)

#__________________________________________________

setup()
daemon()

#while True:
#    loop()

fifo.close()
#arduino.close()
os_exit(1)
#sys.exit()
