#!/bin/bash

[ "${#}" -lt 1 ] && exit 1

device='/dev/input/by-id/usb-Teensyduino_Serial_Keyboard_Mouse_Joystick_1008140-if02-event-kbd'

arg=$(echo "$@" | tr '[:lower:]' '[:upper:]')

if [[ "${arg:0:2}" == '-H' ]] || [[ "${arg:0:3}" == '--H' ]]; then
  cat /home/pi/ADMIN/FILES/KEY_NAMES2 | less
else
  [[ $(echo "$arg" | grep -co "KEY_") -gt 0 ]] && arg=$(echo "$arg" | awk -F'KEY_' '{print $2}')
  arg="KEY_${arg}"

  if [[ $(grep -c -m1 "$arg" KEY_NAMES) -gt 0 ]]; then
    echo -e "pressing \x27$arg\x27 " #> $device\n"
    code="$arg"
    timeout 2 evtest "$device" | grep "($code)" | grep "Event:" &
    PID=$!
    sudo -- bash -c "evemu-event $device --type EV_KEY --code $code --value 1 --sync; evemu-event $device --type EV_KEY --code $code --value 0 --sync" && wait $PID
  else
   echo "key '$arg' not found.."
  fi
fi


#  case $arg in
#   '--help'|'-help'|'-h'|'--h')
#     cat /home/pi/ADMIN/FILES/KEY_NAMES2 | less
#     ;;
#   *)
#     arg=$(echo "$@" | tr '[:lower:]' '[:upper:]')
#     [[ $(echo "$arg" | grep -co "KEY_") -gt 0 ]] && arg=$(echo "$arg" | awk -F'KEY_' '{print $2}')
#     arg="KEY_${arg}"
#     echo "arg: $arg"
#     if [[ $(grep -c -m1 "$arg" KEY_NAMES) -gt 0 ]]; then
#       echo "KEY IS: '$arg'"
#     fi
#     ;;
#  esac

#case "$1" in


#case $(KEY_NAMES2 -- "$1") in

#case "$(cat KEY_NAMES2)

#case "$(ls -ld -- "$1")" in
#    -*) echo 'Regular file' ;;
#    d*) echo 'Directory' ;;
#    *)  echo 'other' ;;
#esac
