#!/bin/bash

teensy_kbd='/dev/input/by-id/usb-Teensyduino_Serial_Keyboard_Mouse_Joystick_1008140-if02-event-kbd'

file_coins_count='/tmp/cafca_coins_cnt'
file_start_count='/tmp/cafca_start_cnt'

coin_key='KEY_C'
start_key='KEY_S'

#____________________________________________________

on_exit() {
  echo -e "\nSTOPPED"
  exit 1
}

read_inputs() {
  local coins_cnt=0
  local start_cnt=0

  local limit_start=20
  local t_start=$limit_start
  local last_start=$(date +%s)

  while read -r line; do
    pressed=$(echo "$line" | grep -E "$coin_key|$start_key" | \
      awk -v C="$coin_key" -v S="$start_key" '{
        if ($2 == C) print "COIN"
        if ($2 == S) print "START"
      }')

    coins_cnt=$(cat "$file_coins_count")
    start_cnt=$(cat "$file_start_count")

    if [[ $pressed == COIN ]]; then
      echo "$(( coins_cnt + 1 ))" | sudo tee $file_coins_count &>/dev/null
    elif [[ $pressed == START ]]; then
      if [[ $coins_cnt -gt 0 ]]; then
        if [[ $start_cnt -gt 0 ]]; then
          t_start=$(( `date +%s` - $last_start ))
          if [[ $t_start -ge $limit_start ]]; then
            echo "$(( start_cnt + 1 ))" | sudo tee $file_start_count &>/dev/null
            t_start=0
            last_start=$(date +%s)
          fi
        else
          echo "$(( start_cnt + 1 ))" | sudo tee $file_start_count &>/dev/null
          t_start=0
          last_start=$(date +%s)
        fi
      fi
    fi
  done< <(thd --dump "$teensy_kbd" 2>&1 |& grep --line-buffered -E "$coin_key|$start_key" | awk -W interactive '{$1=$1;print}' | grep --line-buffered -Ew "EV_KEY $coin_key 1|EV_KEY $start_key 1" 2>&1)
}


trap on_exit EXIT

touch $file_coins_count && echo 0 | sudo tee $file_coins_count &>/dev/null
touch $file_start_count && echo 0 | sudo tee $file_start_count &>/dev/null


read_inputs &

while true; do
  coins=$(cat $file_coins_count)
  start=$(cat $file_start_count)

  clear
  echo -e "COINS: $coins\nSTART: $start"

  sleep 1
done

