#!/bin/bash

home_dir=$(getent passwd pi | cut -d: -f6)
backup_dir="$home_dir/ADMIN/.backup"
dirname=$(date +%Y_%m_%d_%H-%M-%S)
backup_path="$backup_dir/$dirname"
log_file="$backup_dir/backup.log"

include_file='/home/pi/ADMIN/.sys/include.sh'
[ -f $include_file ] && source $include_file
include

#_______________________________________________

[ ! -d $backup_dir ] && sudo mkdir -p $backup_dir
sudo chmod -R 775 $backup_dir

sudo mkdir -p "$backup_path"
sudo touch $log_file

sleep 1

#exec > $log_file 2>&1
exec > >(sudo tee $log_file 2>&1)

#_______________________________________________

echo -e "\n`date`"
echo -e "\nbackup path: $backup_path"

function test_ftp() {
	pass=$(sudo cat $home_dir/ADMIN/.sys/.pass | base64 -d)
	sudo sshpass -p "$pass" sftp dogenigt@data.dogenigt.dk< <( \
	echo -e " \
	  cd public_html_data.dogenigt.dk/pi\n \
	  put $backup_dir/BACKUP.zip\n \
	  ls -la\n \
	  bye\n \
	") 2>&1 \
	| awk '{$1=$1;print}' | grep -P 'Connected|Uploading|(?=.*-rw-*)(?=.*BACKUP.zip)'

	#| grep -E "BACKUP.zip|Uploading" | awk '{$1=$1;print}' | \
        #  awk '{ \
        #    f="BACKUP"; s="Uploading"; \
        #    if ($1 ~ s) { print "sftp> "$0 } \
        #    if ($9 ~ f) { for (i=NF; i>=4; i--) { printf $i" " } } \
        #  }'
        #  #awk -F ' ' '{ f="BACKUP"; s="Uploading"; for (i=1; i<=NF; ++i) { if ( $i ~ f) { print $0 } else if ( $i ~ s) { print $0 }}}'

  echo -e "\nDONE!\nPress any key to continue.\n"
  read -rN1
  clear
}


function test_ftp2() {
  pass=$(sudo cat $home_dir/ADMIN/.sys/.pass | base64 -d)

	sudo sshpass -p "$pass" sftp dogenigt@data.dogenigt.dk< <( \
	echo -e "\
	  cd public_html_data.dogenigt.dk/pi\n\
	  put $backup_dir/BACKUP.zip\n\
	  ls -la\n\
	  bye\n\
	") 2>&1 #\
	#| grep --line-buffered "BACKUP.zip" | awk '{$1=$1;print}' | cut -d' ' -f5- | awk '{for (i=NF;i>0;i--){printf $i" "};printf "\n"}'

  #sudo sshpass -p "$pass" sftp dogenigt@data.dogenigt.dk< <(echo -e "cd public_html_data.dogenigt.dk/pi\nls -la\nbye\n") 2>&1 \
  #| grep --line-buffered "BACKUP.zip" | awk '{$1=$1;print}' | cut -d' ' -f5- | awk '{for (i=NF;i>0;i--){printf $i" "};printf "\n"}'
  #sudo sshpass -p "$pass" sftp dogenigt@data.dogenigt.dk< <(echo -e "cd public_html.data.dogenigt.dk/pi\nbye\n")
  #sudo -u pi bash -c "expect $home_dir/ADMIN/CMD/FTP/sftp-upload.exp $backup_dir/BACKUP.zip"
  echo -e "\nDONE!\nPress any key to continue.\n"
  read -rN1
  clear
}

#cut -d' ' -f5- | awk '{for (i=NF;i>0;i--){printf $i" "};printf "\n"}'

#test_ftp
#exit

while read -r line; do

  path=$(echo $line | cut -d' ' -f1)
  type=$(echo $line | cut -d' ' -f2)

  echo -n "backing up $type: $path -> "

  if [[ "$type" = "FILE" ]]; then
     dir="$backup_path"; dir+=$(echo "$path" | awk -F/ '{ for (i=1; i<NF; i++) printf "%s/", $i ; printf "\n" }')
     sudo mkdir -p "$dir" && sudo chmod -R 775 "$dir"
     echo -e "$dir\n"
     sudo cp -v "$path" "$dir"
  elif [[ "$type" = "DIR" ]]; then
    dir=$(echo "$backup_path$path")
    [ -d $dir ] && sudo chmod -R 775 "$dir" || sudo mkdir -p "$dir" && sudo chmod -R 775 "$dir"
    echo -e "$dir\n"
    sudo cp -rT -v "$path" "$dir"
  elif [[ "$type" = "ALL" ]]; then
    dir=$(echo "$backup_path$path")
    [ -d $dir ] && sudo chmod -R 775 "$dir" || sudo mkdir -p "$dir" && sudo chmod -R 775 "$dir"
    echo -e "$dir\n"
    sudo find "$path" -maxdepth 1 -type f -exec cp -v {} "$dir" \;
  fi

done< <(cat "$backup_dir/.LIST")

folder_size=$(sudo du -sh $backup_path | awk -F' ' '{print $1}' | sed 's/M//g')
echo -e "\nDONE!\n\n" #FOLDER SIZE: $folder_sizeM\n"
#sleep 1

echo -e "ADD TO ARCHIVE? (Y/n)" && read -srN 1 choice_archive

#[ -f $archive_name ] && echo "archive already exists.." || \
case $choice_archive in
  [Yy]) archive_name=$(echo "$backup_path" | awk -F'/' '{print $(NF-0)}' | sed 's/\.//g' | awk '{print $0 ".tar.gz"}')
	#echo -e "\n\nWRITING ARCHIVE \x27$backup_dir/$archive_name\x27\n"
	sudo tar -czvf "$backup_dir/$archive_name" "$backup_path" #&& \
        archive_size=$(sudo du -sh "$backup_dir/$archive_name" | awk -F' ' '{print $1}' | sed 's/M//g')
        compression=$(awk -v var1="$archive_size" -v var2="$folder_size" 'BEGIN { print ( var1 / var2 ) }' | cut -c -4)
        echo -e "\nDONE!\n" #\nARCHIVE SIZE: $archive_sizeM ($compression%)"
        sleep 2
        sudo chmod 775 "$backup_dir/$archive_name"
        sudo rm -R $backup_path
        sleep 1
        echo -e "ADD BACKUP FOLDER TO ZIP? (Y/n)" && read -srN 1 choice_archive

        case $choice_archive in
          [Yy]) clear
            	sudo 7z a -tzip -p1234 "$backup_dir/BACKUP.zip" "$backup_dir/$archive_name"
            	echo -e "\nDONE!\nPress any key to continue.\n"
            	read -rN1
            	clear
            	echo -e "\n"
            	sudo 7z l "$backup_dir/BACKUP.zip" | grep "Listing archive:" -A6 && \
            	sudo 7z l "$backup_dir/BACKUP.zip" | grep "Date" -A1 | cut -d' ' -f 4- | awk '{print $1"       "$2"  "$4"   "$6}' | sed -e "s/-\+//g" && \
            	sudo 7z l "$backup_dir/BACKUP.zip" | grep "Listing archive:" -A100 | tail -n +9 | awk '{split($2,time,":"); print $1" "time[1]":"time[2]" "$4"\t"$6}'
                echo -e "\n $(sudo du -sh $backup_dir/BACKUP.zip)"
                sleep 1
	        echo -e "\nUPLOAD ZIP? (Y/n)" && read -srN 1 choice_upload

                case $choice_upload in
        	  [Yy]) clear
			pass=$(sudo cat $home_dir/ADMIN/.sys/.pass | base64 -d)

			sudo sshpass -p "$pass" sftp dogenigt@data.dogenigt.dk< <( \
			echo -e " \
			  cd public_html_data.dogenigt.dk/pi\n \
			  put $backup_dir/BACKUP.zip\n \
			  ls -la\n \
			  bye\n \
			") 2>&1 \
			| awk '{$1=$1;print}' | grep -P 'Connected|Uploading|(?=.*-rw-*)(?=.*BACKUP.zip)'


			#sudo sshpass -p "$pass" sftp dogenigt@data.dogenigt.dk< <( echo -e "cd public_html_data.dogenigt.dk/pi\nput $backup_dir/BACKUP.zip\nls -la\n\bye\n\") 2>&1 \
                        #| grep --line-buffered "BACKUP.zip" | awk '{$1=$1;print}' | cut -d' ' -f5- | awk '{for (i=NF;i>0;i--){printf $i" "};printf "\n"}'

                        #sudo sshpass -p "$pass" sftp dogenigt@data.dogenigt.dk< <(echo -e "cd public_html.data_dogenigt_dk\nbye\n")
                        #sudo -u pi bash -c "expect $home_dir/ADMIN/CMD/FTP/sftp-upload.exp $backup_dir/BACKUP.zip"
            		echo -e "\nDONE!\nPress any key to continue.\n"
            		read -rN1
            		clear
            		;;
                  *)
                    ;;
	        esac
		;;
          *)
	    ;;
        esac
        ;;
  *)
   ;;
esac

