#!/bin/env python3

from omxplayer.player import OMXPlayer
from pathlib import Path
from time import sleep
from random import randint
import logging
logging.basicConfig(level=logging.INFO)


VIDEO_1_PATH = "/home/pi/downloads/Arcades_In_The_Movies.mp4"
player_log = logging.getLogger("Player 1")

player = OMXPlayer(VIDEO_1_PATH,
        dbus_name='org.mpris.MediaPlayer2.omxplayer1')
player.playEvent += lambda _: player_log.info("Play")
player.pauseEvent += lambda _: player_log.info("Pause")
player.stopEvent += lambda _: player_log.info("Stop")
#player.positionEvent += lambda _: player_log.info("Position")

# it takes about this long for omxplayer to warm up and start displaying a picture on a rpi3

player.pause()
sleep(2.5)
player.set_position(2)

#sleep(2)

#player.set_aspect_mode('stretch')
player.set_aspect_mode('fill')
#player.set_video_pos(0, 0, 200, 200)
player.play()

def randSeek():
  return randint(10, 30)

while True:
  if player.playback_status() == "Playing":
    while player.playback_status() == "Playing":
      sleep(5)
      player.seek(randSeek())


player.quit()
