#!/usr/bin/env python3 -*- coding: utf-8

import serial
import os
import sys
from time import sleep
from datetime import datetime

#__________________________________________________

serial_port = "/dev/ttyACM0"
count_timeout = 5

log_dir = os.path.splitext('/home/pi/ADMIN/.log')[0]
log_file = (str(os.path.splitext(log_dir + '/serialpy')[0])+'.log')
hide = " >/dev/null 2>&1"

def setup():
    try:
        if not os.path.exists(log_file):
            os.system('sudo touch ' + log_file)
            sleep(1)

        os.system('sudo chmod 775 ' + log_file)
        sleep(1)

    except Exception as e:
        print("error writing logfile:",e)

    os.system('echo \x22\x23 SERIAL LOG\n\x23 ' + str(f'{datetime.today():%h %e %Y}') + '\n\x22 | sudo tee ' + log_file + hide)


def writelog(src = ' ', msg = ' '):
    timestr = f'{datetime.today():%T}'
    os.system("echo \x22[" + timestr + "] " + src + ": \x27" + msg + "\x27\x22 | sudo tee -a " + log_file + hide)

def send_msg():
    success = 0
    count = 0

    if os.path.exists(serial_port):
        #print("\nFound serial port",serial_port,"!\n")
        #sleep(1)

        #with serial.Serial('/dev/ttyACM1', 9600, timeout=1) as arduino:
        with serial.Serial(serial_port, 9600, timeout=1) as arduino:
            try:
                sleep(0.1)

                if arduino.isOpen():
                    arduino.reset_input_buffer()
                    #print(f"writing '{msg}' to gun..")
                    arduino.write(msg.encode())
                    writelog('TEENSY',msg)
                    sleep(0.1)

                    if int(wait) > 0:
                        #print("waiting for response..")
                        while count < count_timeout:
                            try:
                                if arduino.inWaiting()==0:
                                    sleep(1)
                                    count = count+1
                                elif arduino.inWaiting()>0:
                                    while arduino.inWaiting()>0:
                                        line = arduino.readline().decode('utf-8').strip()
                                        #print("\nReceived: \x27"+line+"\x27\n\n")
                                        writelog('RPI3B+',line)
                                        sleep(0.1)
                                        arduino.flushInput()
                                        success = 1
                                        os._exit(1)
                                    break
                            except serial.SerialException as se:
                                writelog('ERROR:',se)
                                #print("Serial port error:",se)
                                break
                    arduino.close()

            except Exception as e:
                writelog('ERROR:',e)
                #print(f"Error opening Arduino:",e)

            except KeyboardInterrupt:
                writelog('ERROR:','KeyboardInterrupt')
                #print("KeyboardInterrupt has been caught.")
                arduino.close()
                os._exit(1)
    else:
        writelog('ERROR:','serial_port not found.')
        #print(f"{serial_port} not found...")
        #sleep(5)


#--------------------------------------------------

count = 0
msg = ''
wait = 0
force = 0
success = 0

arg_len = (len(sys.argv)-1)
#print("ARGS:",arg_len,sys.argv)

if arg_len > 0:
    try:
        msg = sys.argv[1]
        if arg_len > 1:
            if sys.argv[2].strip().isdigit():
                wait = sys.argv[2].strip()
        if arg_len > 2:
            if sys.argv[3].strip().isdigit():
                force = sys.argv[3].strip()

        send_msg()

        if (int(force) > 0) and (success < 1):
            while success < 1:
                send_msg()
        os._exit(1)

    except Exception as e:
        writelog('ERROR:','NO ARGS..')
        #print(f"No args provided..")


#while True:
#    loop()
#    #sleep(1)

#fifo.close()
sys.exit()
