#!/bin/bash

log_file='/home/pi/ADMIN/.log/serial.log'
port=$(grep 'serial_teensy' /home/pi/ADMIN/.sys/.settings | cut -d\' -f2)
PID=

cleanup() {
  stty sane
  kill $PID
  wait $PID 2>/dev/null
  printf ';' >/dev/ttyACM0
  exec 3<&-
  echo "DONE"
  exit
}

#trap cleanup EXIT QUIT INT SIGTERM TERM SIGKILL KILL
#trap cleanup QUIT INT SIGTERM TERM SIGKILL KILL

[ ! -f "$log_file" ] && touch "$log_file"
sudo chmod 775 "$log_file"
echo -e "`date +%F`\n" | sudo tee "$log_file" &>/dev/null
#printf '' | sudo tee "$log_file" &>/dev/null

# ------------------------------------------------------------------------------------------------



#stty -F /dev/ttyACM0 9600 -icanon min 2 #cs8 -cstopb -parenb
#printf "${@};" >&3           # send data
#cat <&3                      # read the data

exec 3<>/dev/ttyACM0
#exec 3< /dev/ttyACM0

stty sane && stty -F /dev/ttyACM0 9600 raw -echo

cat <&3 > >( awk -v time="$(echo `date +%T`)" '{print time": "$0}' | sudo tee -a "$log_file" 2>&1) &
PID=$!

#cat /tmp/pyserial.fifo |&  >( awk '{print $0";"}' >&3 )

# -------------------------------------------------------------------------------------------------


while true; do
  INBOX=$(cat /tmp/pyserial.fifo)

  if [[ ${#INBOX} -gt 1 ]]; then
     echo "`date +%T`: RPI3B+ > $INBOX" | sudo tee -a "$log_file" #&> /dev/null
  fi
done


#while true; do
#while [[ $(cat /tmp/pyserial.fifo | wc -l) -lt 1 ]]; do sleep 1; done
#  INBOX=$(cat /tmp/pyserial.fifo)
#  printf "VFD 1 $INBOX;" > /dev/ttyACM0 && sleep 1 #&> /dev/null
#  cleanup
#
#  #if [[ ${#INBOX} -gt 1 ]]; then
#     echo "RPI3B+ > $INBOX" | sudo tee -a "$log_file" #&> /dev/null
#  #  printf "VFD 1 $INBOX;" > /dev/ttyACM0 && sleep 1 #&> /dev/null
#  #fi
#done
