#!/bin/bash

log_file='/home/pi/ADMIN/.log/serial.log'
fifo_file='/tmp/serial.fifo'
path='/dev/ttyACM'

[ ! -f "$log_file" ] && touch "$log_file"; sudo chmod 775 "$log_file"
echo -e "`date +%F`\n" | sudo tee "$log_file" &>/dev/null

#_________________________________________________________________________________

#IFS=$' \t\n'

declare -a inbx
while read line; do
  inbx+=($(echo "$line"))
done < "$FIFO" && \

echo "arr len: ${#arr[@]}"

for a in "${arr[@]}"; do echo "$a"; done

# WORKS!
#echo "start" && while read line; do echo "> $line"; done < "$FIFO" && echo "stop"

#--- clean
IFS=$' \t\n'
rm -f "$FIFO"
exit

#_________________________________________________________________________________

while true; do
  INBOX=$(cat "$fifo_file")

  if [[ ${#INBOX} -gt 1 ]]; then
    dev=0; br=''
    if [[ "${INBOX:1:1}" == ':' ]]; then
      dev_idx="${INBOX:0:1}"
      if [[ $dev_idx =~ ^[0-9]+$ ]]; then
        [[ $dev_idx < 1 ]] && { dev=0; br=';'; } || { dev=1; br=''; }
      fi
      INBOX="${INBOX:2}$br"
    fi

    if [ -c "$path$dev" ]; then
      stty -F "$path$dev" 9600 raw -echok -icanon -echo  min 0 time 30 && \
      printf "$INBOX" > "$path$dev" && echo "`date +%T`: RPI3B+ > '$INBOX'" | sudo tee -a "$log_file" &> /dev/null
      #printf "$INBOX;" > "$path$dev" && echo "`date +%T`: RPI3B+ > '$INBOX;'" | sudo tee -a "$log_file" &> /dev/null

      head -n1 "$path$dev" > >( \
        read response && \
        echo "`date +%T`: TEENSY > '$response'" | sed 's/\r//' | sudo tee -a "$log_file" &>/dev/null && \
        sleep 1 \
      )
      sleep 1
    fi
  fi
done

#if [[ "${INBOX:1:1}" == ':' ]]; then
#  [[ "${INBOX:0:1}" =~ ^[0-9]+$ ]] && dev=$([[ "${INBOX:0:1}" > 0 ]] && echo "1" || echo "0")
#  INBOX="${INBOX:2}"
#fi
