#!/bin/bash

log_file='/home/pi/ADMIN/.log/serial.log'
fifo_file='/tmp/serial.fifo'
path='/dev/ttyACM'

[ ! -f "$log_file" ] && touch "$log_file"; sudo chmod 775 "$log_file"
echo -e "`date +%F`\n" | sudo tee "$log_file" &>/dev/null

while IFS=$'\n' read line; do
  if [[ ${#line} -gt 1 ]]; then
    INBOX="$line"; nom='TEENSY'; dev=0; br=';'; response=''

    if [[ ${INBOX:1:1} == : ]]; then
      [[ ${INBOX:0:1} =~ ^[0-9]+$ ]] && [[ ${INBOX:0:1} > 0 ]] && { nom='PICO'; dev=1; br='\n'; }
      INBOX="${INBOX:2}$br"
    fi
    if [ -c "$path$dev" ]; then
      stty -F "$path$dev" 9600 raw -echok -icanon -echo  min 0 time 30 && \
      printf "$INBOX" > "$path$dev" && echo -ne "`date +%T`: RPI3B+ > '$INBOX' \x7C " | sudo tee -a "$log_file" &> /dev/null

      head -n1 "$path$dev" > >( read response && echo "'$response' < $nom"  | sed -z 's/\r//g' | sudo tee -a "$log_file" &>/dev/null )
      #head -n1 "$path$dev" > >( read response && echo "`date +%T`: TEENSY > '$response'" | sed -z 's/\r//g' | sudo tee -a "$log_file" &>/dev/null )
      #read reponse< <(head -n1 "$path$dev")

      sleep 1
    fi
  fi
done< <( cat <>"$fifo_file" )


#________________________________________________________________________________

working() {
while IFS=$'\n' read line; do
  if [[ ${#line} -gt 1 ]]; then
    INBOX="$line"; nom='TEENSY'; dev=0; br=';'; response=''

    if [[ ${INBOX:1:1} == : ]]; then
      [[ ${INBOX:0:1} =~ ^[0-9]+$ ]] && [[ ${INBOX:0:1} > 0 ]] && { nom='PICO'; dev=1; br='\n'; }
      INBOX="${INBOX:2}$br"
    fi
    if [ -c "$path$dev" ]; then
      stty -F "$path$dev" 9600 raw -echok -icanon -echo  min 0 time 30 && \
      printf "$INBOX" > "$path$dev" && echo -e "`date +%T`: RPI3B+ > '$INBOX'" | sudo tee -a "$log_file" &> /dev/null

      #read reponse< <(head -n1 "$path$dev")

      head -n1 "$path$dev" > >( read response && echo "`date +%T`: TEENSY > '$response'" | sed -z 's/\n//g' | sudo tee -a "$log_file" &>/dev/null )
      sleep 1
    fi
  fi
done< <( cat <>"$fifo_file" )
}

#________________________________________________________________________________


ignore3() {
while IFS=$'\n' read line; do
  if [[ ${#line} -gt 1 ]]; then
    INBOX="$line"; dev=0; br=''; response=''
    if [[ "${INBOX:1:1}" == ':' ]]; then
      dev_idx="${INBOX:0:1}"
      if [[ $dev_idx =~ ^[0-9]+$ ]]; then
        [[ $dev_idx < 1 ]] && { dev=0; br=';'; } || { dev=1; br=''; }
      fi
      INBOX="${INBOX:2}$br"
    fi
    if [ -c "$path$dev" ]; then
      stty -F "$path$dev" 9600 raw -echok -icanon -echo  min 0 time 30 && \
      printf "$INBOX" > "$path$dev" && echo "`date +%T`: RPI3B+ > '$INBOX'" | sudo tee -a "$log_file" &> /dev/null

      head -n1 "$path$dev" > >( \
        read response && \
        echo "`date +%T`: TEENSY > '$response'" | sed 's/\r//' | sudo tee -a "$log_file" &>/dev/null \
      )
      sleep 1
    fi
  fi
done< <( cat <>"$fifo_file" )
}

#________________________________________________________________________________

#lines=()
#cat <>/tmp/new.fifo | while IFS=$'\n' read line; do lines+=("$line"); done &

ignore2() {
while true; do
if [[ ${#lines[@]} -gt 0 ]]; then
  IFS=' ' read -a INBOX <<< "${lines[@]}" && lines=()
  if [[ ${#INBOX} -gt 1 ]]; then
    dev=0; br=''
    if [[ "${INBOX:1:1}" == ':' ]]; then
      dev_idx="${INBOX:0:1}"
      if [[ $dev_idx =~ ^[0-9]+$ ]]; then
        [[ $dev_idx < 1 ]] && { dev=0; br=';'; } || { dev=1; br=''; }
      fi
      INBOX="${INBOX:2}$br"
    fi

    if [ -c "$path$dev" ]; then
      stty -F "$path$dev" 9600 raw -echok -icanon -echo  min 0 time 30 && \
      printf "$INBOX" > "$path$dev" && echo "`date +%T`: RPI3B+ > '$INBOX'" | sudo tee -a "$log_file" &> /dev/null

      head -n1 "$path$dev" > >( \
        read response && \
        echo "`date +%T`: TEENSY > '$response'" | sed 's/\r//' | sudo tee -a "$log_file" &>/dev/null && \
        sleep 1 \
      )
      sleep 1
    fi
  fi
fi
done
}

# ----------------------------------------------------------------------------

ignore() {
while true; do
  INBOX=$(cat "$fifo_file")

  if [[ ${#INBOX} -gt 1 ]]; then
    dev=0; br=''
    if [[ "${INBOX:1:1}" == ':' ]]; then
      dev_idx="${INBOX:0:1}"
      if [[ $dev_idx =~ ^[0-9]+$ ]]; then
        [[ $dev_idx < 1 ]] && { dev=0; br=';'; } || { dev=1; br=''; }
      fi
      INBOX="${INBOX:2}$br"
    fi

    if [ -c "$path$dev" ]; then
      stty -F "$path$dev" 9600 raw -echok -icanon -echo  min 0 time 30 && \
      printf "$INBOX" > "$path$dev" && echo "`date +%T`: RPI3B+ > '$INBOX'" | sudo tee -a "$log_file" &> /dev/null

      head -n1 "$path$dev" > >( \
        read response && \
        echo "`date +%T`: TEENSY > '$response'" | sed 's/\r//' | sudo tee -a "$log_file" &>/dev/null && \
        sleep 1 \
      )
      sleep 1
    fi
  fi
done
}

#cleanup() {
#  echo "CLEANING UP"; IFS=$' \t\n'; rm -r /tmp/new.fifo; exit
#}
#trap cleanup QUIT INT SIGTERM TERM SIGKILL KILL

#if [[ "${INBOX:1:1}" == ':' ]]; then
#  [[ "${INBOX:0:1}" =~ ^[0-9]+$ ]] && dev=$([[ "${INBOX:0:1}" > 0 ]] && echo "1" || echo "0")
#  INBOX="${INBOX:2}"
#fi
