#!/bin/bash

HOMEDIR=$(getent passwd pi | cut -d: -f6)
cafca_dir="$HOMEDIR/CAFCA/data"
state_file="$cafca_dir/.states"

retroarch=$(ps -ef | grep -v grep | grep -c -m1 retroarch)
emustation=$(ps -ef | grep -v grep | grep -c -m1 emulationstation)

Main() {

  if [ "$retroarch" -gt 0 ]; then
    sudo pkill retroarch
  elif [ "$emustation" -gt 0 ]; then
    /usr/bin/printf '\215' > /tmp/vkbdd.fifo
    sleep 5
    clear
    #sudo killall emulationstation
  else
    sudo reboot
    #clear && tput 15 25 && echo "PRESS AGAIN TO REBOOT"
  fi
}

update_state() {
  clear

  game_loaded=$(grep "GAME_LOADED" "$state_file" | cut -d= -f2)
  echo -e "\nGAME LOADED: $game_loaded"

  if [[ $game_loaded > 0 ]]; then
    credits=$(grep "COINS_COUNT" "$state_file" | cut -d= -f2)

    if [[ $credits < 1 ]]; then
      inotifywait -e CLOSE_WRITE,CLOSE_NOWRITE -t 1 "$state_file"
      sudo sed -i '/COIN_INSERTED/d' "$state_file"
      echo "COIN_INSERTED=1" | sudo tee -a "$state_file"
    fi

    credits=$(( credits + 1 ))

    inotifywait -e CLOSE_WRITE,CLOSE_NOWRITE -t 1 "$state_file"
    sudo sed -i '/COINS_COUNT/d' "$state_file"
    echo "COINS_COUNT=$credits" | sudo tee -a "$state_file"
  fi

}


function file_ready() {
  if inotifywait -e CLOSE_WRITE,CLOSE_NOWRITE -t 2 "$state_file"; then
    return 0
  else
    return 1
  fi
}

update_state
exit
