#!/bin/bash

if [[ ${#} -gt 0 ]]; then
   echo "args:       ${@}"
   operator=${1}
else
  operator=0
fi

game_table='/home/pi/CAFCA/data/mame-libretro/game_table'
rc_log='/dev/shm/runcommand.log'
ra_log='/home/pi/CAFCA/log/retroarch/retroarch.log'
game=$(grep "lookup name" "$ra_log" | awk -F' ' '{print $8}' | cut -d. -f1)
game_listed=$(grep -wc "$game" "$game_table")
credits=0

echo "GAME:       $game"
echo "LISTED:     $game_listed"

get_data() {
    data=$(grep -w "$game" "$game_table" | awk '$1=$1 {print}')
    data_reg=$(echo "$data" | awk '{print $3}'); data_reg=$(( data_reg + operator ))
    data_offs=$(echo "$data" | awk '{print $2}')
    scan_args="option region_scan_level 3; reset; dregions !$data_reg; lregions; exit"
    reg_offs=$(sudo scanmem -p `pidof retroarch` -c"$scan_args" 2>&1 |& grep --line-buffered -A1 "lregions" | awk 'NR==2' | awk '$1=$1 {print}' | cut -d] -f2 | awk -F" " '{print $1}' | cut -d, -f1)

    echo "data_reg:   $data_reg"
    echo "data_offs:  $data_offs"
    echo "reg_offs:   0x$reg_offs"
    echo ""
}

dump_addr() {
  BASE="${1}"
  OFFS="${2}"
  printf -v ADDR "0x%X\n" $(( BASE + OFFS)) &>/dev/null
  ADDR=$(echo "$ADDR" | tr '[A-Z]' '[a-z]')
  VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')
  echo "dumpAddr(): $ADDR - VAL: $VAL"
}

if [[ $game_listed -gt 0 ]]; then
  get_data
  sleep 1

  while true; do
    dump_addr "0x$reg_offs" "$data_offs"
    sleep 2
  done

else
    echo "game not listed."
fi
