#!/bin/bash

admin_dir='/home/pi/ADMIN'
cafca_dir='/home/pi/CAFCA'
log_file="$cafca_dir/log/GUN.log"
gun_serial_port='/dev/ttyACM1'
serial_script="$cafca_dir/cmd/serial_gun.py"

debug=1

(( $debug )) && exec > >(sudo tee -a "$log_file" 2>&1)

[[ ${#} -lt 1 ]] && echo "no args." && exit

system="${1}"
game="${2}"
data_file="$cafca_dir/data/$system/games/$game/info.dat"

(( $debug )) && echo "data_file: $data_file"


print_msg() {
 if [[ $# -gt 0 ]]; then
    msg="$@"
    (( $debug )) && echo "msg: $msg"
    if [ -c "$gun_serial_port" ]; then
      stty 9600 cs8 cread -cstopb -noflsh -icanon -echo -echok -imaxbel -F "$gun_serial_port" \
      && printf "$msg\n" > "$gun_serial_port"
      sleep 1
    fi
 fi
}

#stty sane
print_msg "LOADED"

if [ -f "$data_file" ]; then
  while read line; do
    key=$(echo "$line" | cut -d' ' -f1 | cut -d'_' -f2)
    val=$(echo "$line" | cut -d' ' -f2-)
    print_msg "$key $val"
  done< <(cat "$data_file" | awk 'NR > 2')
fi

while [[ $(ps -ef | grep -v grep | grep -m1 -c retroarch) -gt 0 ]]; do
  #echo "PING"
  sleep 1
done

print_msg "UNLOAD"

exit

