#!/bin/bash

cafca_dir='/home/pi/CAFCA'
cafca_script="$cafca_dir/CAFCA.sh"
cafca_log="$cafca_dir/log/CAFCA.log"

system=$(cat /dev/shm/runcommand.info | awk 'NR==1')
game=$(cat /dev/shm/runcommand.info | awk -F/ 'NR==3 {print $NF}' | cut -d. -f1)
cafca_pid=$(grep "PID" "$cafca_dir/data/.states" | cut -d= -f2)
cafca_sid=$(grep "SID" "$cafca_dir/data/.states" | cut -d= -f2)

fifo_file='/tmp/serial.fifo'
timeout=3

exec > >(sudo tee -a "$cafca_log" 2>&1) &>/dev/null

echo -e "0:GAME_STOPPED 1" > "$fifo_file"
#printf "0:GAME_STOPPED 1" > "$fifo_file"

sudo sed -i '/GAME_LOADED/d' /home/pi/ADMIN/.sys/.states && sleep 1 && echo "BOOL GAME_LOADED=0" | sudo tee -a /home/pi/ADMIN/.sys/.states &>/dev/null

sleep $timeout

echo -e "\n_______________________________________\nRUNCMD END:"
echo -e "\nSESSION ID: $cafca_sid\n"

function killCafca() {
  for p in $(pgrep -s "$cafca_sid"); do
    sudo kill -TERM "$p"
    echo "killing: $p"
  done
}

echo -e "0:VFD 4   LOADING MENU" > "$fifo_file"
#printf '0:VFD 4   LOADING MENU' > "$fifo_file"

killCafca

sudo cp -f "$cafca_dir/data/.states.default" "$cafca_dir/data/.states"

sudo sed -i '/UI/d' /home/pi/ADMIN/.sys/.states && sleep 1 && echo "VAR UI=ES" | sudo tee -a /home/pi/ADMIN/.sys/.states &>/dev/null

if [[ "$system" == mame-libretro ]]; then
  if [[ "$game" == defender ]]; then
    path=$(cat /dev/shm/runcommand.info | awk 'NR==3' | rev | cut -d/ -f2- | rev)
    [ -f "$path/mame2003/nvram/$game.nv" ] && sudo rm "$path/mame2003/nvram/$game.nv"
  fi
fi


#if [[ $(grep GAME_TYPE "/home/pi/CAFCA/data/.states" | cut -d= -f2) == GUN  ]]; then
#  echo "  GAME_TYPE IS GUN!"
#  if [ -c /dev/ttyACM1 ]; then
#    sudo python3 /home/pi/CAFCA/cmd/serial_gun.py "UNLOAD" "1" "1" &
#    wait $!
#  fi
#fi


echo "RUNCMD DONE!"

exit
